/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.options;

import alluxio.security.authorization.Permission;
import com.google.common.base.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CreateOptions {
    private boolean mCreateParent = false;
    private boolean mEnsureAtomic = true;
    private Permission mPermission = Permission.defaults().applyFileUMask();

    public static CreateOptions defaults() {
        return new CreateOptions();
    }

    private CreateOptions() {
    }

    public boolean getCreateParent() {
        return this.mCreateParent;
    }

    public Permission getPermission() {
        return this.mPermission;
    }

    public boolean isEnsureAtomic() {
        return this.mEnsureAtomic;
    }

    public CreateOptions setCreateParent(boolean createParent) {
        this.mCreateParent = createParent;
        return this;
    }

    public CreateOptions setEnsureAtomic(boolean atomic) {
        this.mEnsureAtomic = atomic;
        return this;
    }

    public CreateOptions setPermission(Permission permission) {
        this.mPermission = permission;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateOptions)) {
            return false;
        }
        CreateOptions that = (CreateOptions)o;
        return this.mCreateParent == that.mCreateParent && this.mEnsureAtomic == that.mEnsureAtomic && Objects.equal((Object)this.mPermission, (Object)that.mPermission);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mCreateParent, this.mEnsureAtomic, this.mPermission});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("createParent", this.mCreateParent).add("ensureAtomic", this.mEnsureAtomic).add("permission", (Object)this.mPermission).toString();
    }
}

