/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.security.group.GroupMappingService;
import alluxio.util.ShellUtils;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CommonUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final String ALPHANUM = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final Random RANDOM = new Random();

    public static long getCurrentMs() {
        return System.currentTimeMillis();
    }

    public static <T> String listToString(List<T> list) {
        StringBuilder sb = new StringBuilder();
        for (T s : list) {
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static <T> String argsToString(String separator, T ... args) {
        StringBuilder sb = new StringBuilder();
        for (T s : args) {
            if (sb.length() != 0) {
                sb.append(separator);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String[] toStringArray(ArrayList<String> src) {
        String[] ret = new String[src.size()];
        return src.toArray(ret);
    }

    public static String randomAlphaNumString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(ALPHANUM.charAt(RANDOM.nextInt(ALPHANUM.length())));
        }
        return sb.toString();
    }

    public static byte[] randomBytes(int length) {
        byte[] result = new byte[length];
        RANDOM.nextBytes(result);
        return result;
    }

    public static void sleepMs(long timeMs) {
        CommonUtils.sleepMs(null, timeMs);
    }

    public static void sleepMs(Logger logger, long timeMs) {
        try {
            Thread.sleep(timeMs);
        }
        catch (InterruptedException e) {
            if (logger != null) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            Thread.currentThread().interrupt();
        }
    }

    public static void warmUpLoop() {
        for (int k = 0; k < 10000000; ++k) {
        }
    }

    public static <T> T createNewClassInstance(Class<T> cls, Class<?>[] ctorClassArgs, Object[] ctorArgs) throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, InvocationTargetException {
        if (ctorClassArgs == null) {
            return cls.newInstance();
        }
        Constructor<T> ctor = cls.getConstructor(ctorClassArgs);
        return ctor.newInstance(ctorArgs);
    }

    public static List<String> getUnixGroups(String user) throws IOException {
        String result;
        ArrayList<String> groups = new ArrayList<String>();
        try {
            result = ShellUtils.execCommand(ShellUtils.getGroupsForUserCommand(user));
        }
        catch (ShellUtils.ExitCodeException e) {
            LOG.warn("got exception trying to get groups for user " + user + ": " + e.getMessage());
            return groups;
        }
        StringTokenizer tokenizer = new StringTokenizer(result, "[ \t\n\r\f]");
        while (tokenizer.hasMoreTokens()) {
            groups.add(tokenizer.nextToken());
        }
        return groups;
    }

    public static void waitFor(String description, Function<Void, Boolean> condition) {
        while (!((Boolean)condition.apply(null)).booleanValue()) {
            CommonUtils.sleepMs(20L);
        }
    }

    public static void waitFor(String description, Function<Void, Boolean> condition, int timeoutMs) {
        CommonUtils.waitFor(description, condition, timeoutMs, 20);
    }

    public static void waitFor(String description, Function<Void, Boolean> condition, int timeoutMs, int intervalMs) {
        long start = System.currentTimeMillis();
        while (!((Boolean)condition.apply(null)).booleanValue()) {
            if (System.currentTimeMillis() - start > (long)timeoutMs) {
                throw new RuntimeException("Timed out waiting for " + description);
            }
            CommonUtils.sleepMs(intervalMs);
        }
    }

    public static String getPrimaryGroupName(String userName) throws IOException {
        List<String> groups = CommonUtils.getGroups(userName);
        return groups != null && groups.size() > 0 ? groups.get(0) : "";
    }

    public static List<String> getGroups(String userName) throws IOException {
        GroupMappingService groupMappingService = GroupMappingService.Factory.get();
        return groupMappingService.getGroups(userName);
    }

    public static String stripSuffixIfPresent(String key, String suffix) {
        if (key.endsWith(suffix)) {
            return key.substring(0, key.length() - suffix.length());
        }
        return key;
    }

    public static String stripPrefixIfPresent(String key, String prefix) {
        if (key.startsWith(prefix)) {
            return key.substring(prefix.length());
        }
        return key;
    }

    public static boolean isUfsObjectStorage(String ufsAddress) {
        return ufsAddress.startsWith("s3://") || ufsAddress.startsWith("s3n://") || ufsAddress.startsWith("s3a://") || ufsAddress.startsWith("gs://") || ufsAddress.startsWith("swift://") || ufsAddress.startsWith("oss://");
    }

    public static String getValueFromStaticMapping(String mapping, String key) {
        Map m = Splitter.on((String)";").omitEmptyStrings().trimResults().withKeyValueSeparator("=").split((CharSequence)mapping);
        return (String)m.get(key);
    }

    public static Throwable getRootCause(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    private CommonUtils() {
    }
}

