/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.util.io.PathUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");

    private ConfigurationUtils() {
    }

    public static Properties loadPropertiesFromResource(String resourceName) {
        Properties properties = new Properties();
        InputStream inputStream = Configuration.class.getClassLoader().getResourceAsStream(resourceName);
        if (inputStream == null) {
            return null;
        }
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            LOG.error("Unable to load default Alluxio properties file {}", (Object)resourceName, (Object)e);
            return null;
        }
        return properties;
    }

    public static Properties loadPropertiesFromFile(String filePath) {
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(filePath);){
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            LOG.error("Unable to load properties file {}", (Object)filePath, (Object)e);
            return null;
        }
        return properties;
    }

    public static Properties searchPropertiesFile(String propertiesFile, String[] confPathList) {
        if (propertiesFile == null || confPathList == null) {
            return null;
        }
        for (String path : confPathList) {
            String file = PathUtils.concatPath(path, propertiesFile);
            Properties properties = ConfigurationUtils.loadPropertiesFromFile(file);
            if (properties == null) continue;
            LOG.info("Configuration file {} loaded.", (Object)file);
            return properties;
        }
        return ConfigurationUtils.loadPropertiesFromResource(propertiesFile);
    }

    public static boolean masterHostConfigured() {
        boolean usingZk = Configuration.getBoolean(PropertyKey.ZOOKEEPER_ENABLED) && Configuration.containsKey(PropertyKey.ZOOKEEPER_ADDRESS);
        return Configuration.containsKey(PropertyKey.MASTER_HOSTNAME) || usingZk;
    }
}

