/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.security.authorization.Mode;
import alluxio.util.CommonUtils;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Locale;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FormatUtils {
    public static String parametersToString(Object ... objs) {
        StringBuilder sb = new StringBuilder("(");
        if (objs != null) {
            for (int k = 0; k < objs.length; ++k) {
                if (k != 0) {
                    sb.append(", ");
                }
                if (objs[k] == null) {
                    sb.append("null");
                    continue;
                }
                sb.append(objs[k].toString());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static String byteBufferToString(ByteBuffer buf) {
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < buf.limit() / 4; ++k) {
            if (k != 0) {
                sb.append(" ");
            }
            sb.append(buf.getInt());
        }
        return sb.toString();
    }

    public static String byteArrayToHexString(byte[] bytes) {
        return FormatUtils.byteArrayToHexString(bytes, "0x", " ");
    }

    public static String byteArrayToHexString(byte[] bytes, String prefix, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(String.format("%s%02x", prefix, bytes[i]));
            if (i == bytes.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String formatTimeTakenMs(long startTimeMs, String message) {
        return message + " took " + (CommonUtils.getCurrentMs() - startTimeMs) + " ms.";
    }

    public static String formatTimeTakenNs(long startTimeNs, String message) {
        return message + " took " + (System.nanoTime() - startTimeNs) + " ns.";
    }

    public static String getSizeFromBytes(long bytes) {
        double ret = bytes;
        if (ret <= 5120.0) {
            return String.format(Locale.ENGLISH, "%.2fB", ret);
        }
        if ((ret /= 1024.0) <= 5120.0) {
            return String.format(Locale.ENGLISH, "%.2fKB", ret);
        }
        if ((ret /= 1024.0) <= 5120.0) {
            return String.format(Locale.ENGLISH, "%.2fMB", ret);
        }
        if ((ret /= 1024.0) <= 5120.0) {
            return String.format(Locale.ENGLISH, "%.2fGB", ret);
        }
        if ((ret /= 1024.0) <= 5120.0) {
            return String.format(Locale.ENGLISH, "%.2fTB", ret);
        }
        return String.format(Locale.ENGLISH, "%.2fPB", ret /= 1024.0);
    }

    public static long parseSpaceSize(String spaceSize) {
        int index;
        double alpha = 1.0E-4;
        String ori = spaceSize;
        String end = "";
        for (index = spaceSize.length() - 1; index >= 0 && (spaceSize.charAt(index) > '9' || spaceSize.charAt(index) < '0'); --index) {
            end = spaceSize.charAt(index) + end;
        }
        spaceSize = spaceSize.substring(0, index + 1);
        double ret = Double.parseDouble(spaceSize);
        if ((end = end.toLowerCase()).isEmpty() || end.equals("b")) {
            return (long)(ret + alpha);
        }
        if (end.equals("kb")) {
            return (long)(ret * 1024.0 + alpha);
        }
        if (end.equals("mb")) {
            return (long)(ret * 1048576.0 + alpha);
        }
        if (end.equals("gb")) {
            return (long)(ret * 1.073741824E9 + alpha);
        }
        if (end.equals("tb")) {
            return (long)(ret * 1.099511627776E12 + alpha);
        }
        if (end.equals("pb")) {
            BigDecimal pBDecimal = new BigDecimal(0x4000000000000L);
            return pBDecimal.multiply(BigDecimal.valueOf(ret)).longValue();
        }
        throw new IllegalArgumentException("Fail to parse " + ori + " to bytes");
    }

    public static String formatMode(short mode, boolean directory) {
        StringBuilder str = new StringBuilder();
        if (directory) {
            str.append("d");
        } else {
            str.append("-");
        }
        str.append(new Mode(mode).toString());
        return str.toString();
    }

    private FormatUtils() {
    }
}

