/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.master.block.BlockId;
import java.security.SecureRandom;
import java.util.UUID;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class IdUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    public static final long INVALID_FILE_ID = -1L;
    public static final long INVALID_WORKER_ID = -1L;
    private static SecureRandom sRandom = new SecureRandom();

    private IdUtils() {
    }

    public static long createFileId(long containerId) {
        long id = BlockId.createBlockId(containerId, BlockId.getMaxSequenceNumber());
        if (id == -1L) {
            LOG.warn("Created file id -1, which is invalid");
        }
        return id;
    }

    public static long fileIdFromBlockId(long blockId) {
        return IdUtils.createFileId(BlockId.getContainerId(blockId));
    }

    public static String createRpcId() {
        return UUID.randomUUID().toString();
    }

    public static synchronized long getRandomNonNegativeLong() {
        return Math.abs(sRandom.nextLong());
    }
}

