/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.security.authentication.AuthType;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SecurityUtils {
    private SecurityUtils() {
    }

    public static boolean isSecurityEnabled() {
        return SecurityUtils.isAuthenticationEnabled() && SecurityUtils.isAuthorizationEnabled();
    }

    public static boolean isAuthenticationEnabled() {
        return !Configuration.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class).equals((Object)AuthType.NOSASL);
    }

    public static boolean isAuthorizationEnabled() {
        return Configuration.getBoolean(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_ENABLED);
    }
}

