/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ShellUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    public static final String SET_PERMISSION_COMMAND = "chmod";
    public static final String TOKEN_SEPARATOR_REGEX = "[ \t\n\r\f]";
    private Process mProcess;
    private int mExitCode;
    private String[] mCommand;
    private StringBuffer mOutput;

    public static String[] getGroupsForUserCommand(String user) {
        return new String[]{"bash", "-c", "id -gn " + user + "; id -Gn " + user};
    }

    public static String[] getSetPermissionCommand(String perm, String filePath) {
        return new String[]{SET_PERMISSION_COMMAND, perm, filePath};
    }

    private ShellUtils(String[] execString) {
        this.mCommand = (String[])execString.clone();
    }

    protected void run() throws IOException {
        this.mExitCode = 0;
        this.runCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCommand() throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.getExecString());
        this.mProcess = builder.start();
        BufferedReader inReader = new BufferedReader(new InputStreamReader(this.mProcess.getInputStream(), Charset.defaultCharset()));
        StringBuffer errMsg = new StringBuffer();
        try {
            this.parseExecResult(inReader);
            String line = inReader.readLine();
            while (line != null) {
                line = inReader.readLine();
            }
            this.mExitCode = this.mProcess.waitFor();
            if (this.mExitCode != 0) {
                throw new ExitCodeException(this.mExitCode, errMsg.toString());
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            try {
                InputStream stdout;
                InputStream inputStream = stdout = this.mProcess.getInputStream();
                synchronized (inputStream) {
                    inReader.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Error while closing the input stream", (Throwable)e);
            }
            this.mProcess.destroy();
        }
    }

    protected String[] getExecString() {
        return this.mCommand;
    }

    protected void parseExecResult(BufferedReader lines) throws IOException {
        int nRead;
        this.mOutput = new StringBuffer();
        char[] buf = new char[512];
        while ((nRead = lines.read(buf, 0, buf.length)) > 0) {
            this.mOutput.append(buf, 0, nRead);
        }
    }

    public String getOutput() {
        return this.mOutput == null ? "" : this.mOutput.toString();
    }

    public Process getProcess() {
        return this.mProcess;
    }

    public int getExitCode() {
        return this.mExitCode;
    }

    public static String execCommand(String ... cmd) throws IOException {
        ShellUtils exec = new ShellUtils(cmd);
        exec.run();
        return exec.getOutput();
    }

    public static class ExitCodeException
    extends IOException {
        private static final long serialVersionUID = -6520494427049734809L;
        private final int mExitCode;

        public ExitCodeException(int exitCode, String message) {
            super(message);
            this.mExitCode = exitCode;
        }

        public int getExitCode() {
            return this.mExitCode;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("ExitCodeException ");
            sb.append("exitCode=").append(this.mExitCode).append(": ");
            sb.append(super.getMessage());
            return sb.toString();
        }
    }
}

