/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import com.google.common.base.Joiner;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class URIUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    public static final char QUERY_SEPARATOR = '&';
    public static final char QUERY_KEY_VALUE_SEPARATOR = '=';

    private URIUtils() {
    }

    public static String generateQueryString(Map<String, String> queryMap) {
        if (queryMap == null || queryMap.isEmpty()) {
            return null;
        }
        ArrayList<String> pairs = new ArrayList<String>(queryMap.size());
        try {
            for (Map.Entry<String, String> entry : queryMap.entrySet()) {
                pairs.add(URLEncoder.encode(entry.getKey(), "UTF-8") + '=' + URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        Joiner joiner = Joiner.on((char)'&');
        return joiner.join(pairs);
    }

    public static Map<String, String> parseQueryString(String query) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (query == null || query.isEmpty()) {
            return queryMap;
        }
        String[] entries = query.split(String.valueOf('&'));
        try {
            for (String entry : entries) {
                String key;
                String[] parts = entry.split(String.valueOf('='));
                if (parts.length == 0) continue;
                if (parts.length == 1) {
                    key = URLDecoder.decode(parts[0], "UTF-8");
                    queryMap.put(key, "");
                    continue;
                }
                key = URLDecoder.decode(parts[0], "UTF-8");
                String value = URLDecoder.decode(parts[1], "UTF-8");
                queryMap.put(key, value);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return queryMap;
    }
}

