/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.DeleteOptions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class UnderFileSystemUtils {
    public static void deleteDirIfExists(String path) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.Factory.get(path);
        if (ufs.isDirectory(path) && !ufs.deleteDirectory(path, DeleteOptions.defaults().setRecursive(true))) {
            throw new IOException("Folder " + path + " already exists but can not be deleted.");
        }
    }

    public static void mkdirIfNotExists(String path) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.Factory.get(path);
        if (!ufs.isDirectory(path) && !ufs.mkdirs(path)) {
            throw new IOException("Failed to make folder: " + path);
        }
    }

    public static void touch(String path) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.Factory.get(path);
        OutputStream os = ufs.create(path);
        os.close();
    }

    public static void deleteFileIfExists(String path) {
        UnderFileSystem ufs = UnderFileSystem.Factory.get(path);
        try {
            if (ufs.isFile(path)) {
                ufs.deleteFile(path);
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private UnderFileSystemUtils() {
    }
}

