/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.executor;

import alluxio.util.ThreadFactoryUtils;
import alluxio.util.executor.ExecutorServiceFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ExecutorServiceFactories {
    public static ExecutorServiceFactory fixedThreadPoolExecutorServiceFactory(final String name, final int nThreads) {
        return new ExecutorServiceFactory(){

            @Override
            public ExecutorService create() {
                return Executors.newFixedThreadPool(nThreads, ThreadFactoryUtils.build(name + "-%d", true));
            }
        };
    }

    public static ExecutorServiceFactory constantExecutorServiceFactory(final ExecutorService executorService) {
        return new ExecutorServiceFactory(){

            @Override
            public ExecutorService create() {
                return executorService;
            }
        };
    }

    private ExecutorServiceFactories() {
    }
}

