/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.io;

import alluxio.exception.InvalidPathException;
import alluxio.util.io.PathUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");

    public static void changeLocalFileGroup(String path, String group) throws IOException {
        UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
        PosixFileAttributeView view = Files.getFileAttributeView(Paths.get(path, new String[0]), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        GroupPrincipal groupPrincipal = lookupService.lookupPrincipalByGroupName(group);
        view.setGroup(groupPrincipal);
    }

    public static void changeLocalFilePermission(String filePath, String perms) throws IOException {
        Files.setPosixFilePermissions(Paths.get(filePath, new String[0]), PosixFilePermissions.fromString(perms));
    }

    public static void changeLocalFileToFullPermission(String filePath) throws IOException {
        FileUtils.changeLocalFilePermission(filePath, "rwxrwxrwx");
    }

    public static String getLocalFileOwner(String filePath) throws IOException {
        PosixFileAttributes attr = Files.readAttributes(Paths.get(filePath, new String[0]), PosixFileAttributes.class, new LinkOption[0]);
        return attr.owner().getName();
    }

    public static String getLocalFileGroup(String filePath) throws IOException {
        PosixFileAttributes attr = Files.readAttributes(Paths.get(filePath, new String[0]), PosixFileAttributes.class, new LinkOption[0]);
        return attr.group().getName();
    }

    public static short getLocalFileMode(String filePath) throws IOException {
        Set<PosixFilePermission> permission = Files.readAttributes(Paths.get(filePath, new String[0]), PosixFileAttributes.class, new LinkOption[0]).permissions();
        int mode = 0;
        for (PosixFilePermission action : PosixFilePermission.values()) {
            mode <<= 1;
            mode += permission.contains((Object)action) ? 1 : 0;
        }
        return (short)mode;
    }

    public static void changeLocalFileUser(String path, String user) throws IOException {
        UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
        PosixFileAttributeView view = Files.getFileAttributeView(Paths.get(path, new String[0]), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        UserPrincipal userPrincipal = lookupService.lookupPrincipalByName(user);
        view.setOwner(userPrincipal);
    }

    public static void setLocalDirStickyBit(String dir) {
        try {
            if (dir.startsWith("/")) {
                Runtime.getRuntime().exec("chmod +t " + dir);
            }
        }
        catch (IOException e) {
            LOG.info("Can not set the sticky bit of the directory: {}", (Object)dir, (Object)e);
        }
    }

    public static void createBlockPath(String path) throws IOException {
        try {
            FileUtils.createStorageDirPath(PathUtils.getParent(path));
        }
        catch (InvalidPathException e) {
            throw new IOException("Failed to create block path, get parent path of " + path + "failed", e);
        }
        catch (IOException e) {
            throw new IOException("Failed to create block path " + path, e);
        }
    }

    public static void move(String srcPath, String dstPath) throws IOException {
        com.google.common.io.Files.move((File)new File(srcPath), (File)new File(dstPath));
    }

    public static void delete(String path) throws IOException {
        File file = new File(path);
        if (!file.delete()) {
            throw new IOException("Failed to delete " + path);
        }
    }

    public static void deletePathRecursively(String path) throws IOException {
        Path root = Paths.get(path, new String[0]);
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (e == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw e;
            }
        });
    }

    public static void createStorageDirPath(String path) throws IOException {
        File dir = new File(path);
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdirs()) {
            if (dir.exists()) {
                return;
            }
            throw new IOException("Failed to create folder " + path);
        }
        String absolutePath = dir.getAbsolutePath();
        FileUtils.changeLocalFileToFullPermission(absolutePath);
        FileUtils.setLocalDirStickyBit(absolutePath);
        LOG.info("Folder {} was created!", (Object)path);
    }

    public static void createFile(String filePath) throws IOException {
        File file = new File(filePath);
        com.google.common.io.Files.createParentDirs((File)file);
        if (!file.createNewFile()) {
            throw new IOException("File already exists " + filePath);
        }
    }

    public static void createDir(String path) throws IOException {
        new File(path).mkdirs();
    }

    public static boolean exists(String path) {
        return new File(path).exists();
    }

    private FileUtils() {
    }
}

