/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.io;

import alluxio.exception.ExceptionMessage;
import alluxio.exception.InvalidPathException;
import alluxio.util.OSUtils;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FilenameUtils;

@ThreadSafe
public final class PathUtils {
    private static final String TEMPORARY_SUFFIX_FORMAT = ".alluxio.0x%016X.tmp";
    private static final int TEMPORARY_SUFFIX_LENGTH = String.format(".alluxio.0x%016X.tmp", 0).length();

    public static String cleanPath(String path) throws InvalidPathException {
        PathUtils.validatePath(path);
        return FilenameUtils.separatorsToUnix((String)FilenameUtils.normalizeNoEndSeparator((String)path));
    }

    public static String concatPath(Object base, Object ... paths) throws IllegalArgumentException {
        Preconditions.checkArgument((base != null ? 1 : 0) != 0, (Object)"Failed to concatPath: base is null");
        Preconditions.checkArgument((paths != null ? 1 : 0) != 0, (Object)"Failed to concatPath: a null set of paths");
        ArrayList<String> trimmedPathList = new ArrayList<String>();
        String trimmedBase = CharMatcher.is((char)"/".charAt(0)).trimTrailingFrom((CharSequence)base.toString().trim());
        trimmedPathList.add(trimmedBase);
        for (Object path : paths) {
            String trimmedPath;
            if (path == null || (trimmedPath = CharMatcher.is((char)"/".charAt(0)).trimFrom((CharSequence)path.toString().trim())).isEmpty()) continue;
            trimmedPathList.add(trimmedPath);
        }
        if (trimmedPathList.size() == 1 && trimmedBase.isEmpty()) {
            return "/";
        }
        return Joiner.on((String)"/").join(trimmedPathList);
    }

    public static String getParent(String path) throws InvalidPathException {
        String cleanedPath = PathUtils.cleanPath(path);
        String name = FilenameUtils.getName((String)cleanedPath);
        String parent = cleanedPath.substring(0, cleanedPath.length() - name.length() - 1);
        if (parent.isEmpty()) {
            return "/";
        }
        return parent;
    }

    public static String[] getPathComponents(String path) throws InvalidPathException {
        if (PathUtils.isRoot(path = PathUtils.cleanPath(path))) {
            return new String[]{""};
        }
        return path.split("/");
    }

    public static String subtractPaths(String path, String prefix) throws InvalidPathException {
        String cleanedPrefix;
        String cleanedPath = PathUtils.cleanPath(path);
        if (cleanedPath.equals(cleanedPrefix = PathUtils.cleanPath(prefix))) {
            return "";
        }
        if (!PathUtils.hasPrefix(cleanedPath, cleanedPrefix)) {
            throw new RuntimeException(String.format("Cannot subtract %s from %s because it is not a prefix", prefix, path));
        }
        int prefixLen = cleanedPrefix.length();
        int charsToDrop = PathUtils.isRoot(cleanedPrefix) ? prefixLen : prefixLen + 1;
        return cleanedPath.substring(charsToDrop, cleanedPath.length());
    }

    public static boolean hasPrefix(String path, String prefix) throws InvalidPathException {
        String[] prefixComponents;
        String[] pathComponents = PathUtils.getPathComponents(path);
        if (pathComponents.length < (prefixComponents = PathUtils.getPathComponents(prefix)).length) {
            return false;
        }
        for (int i = 0; i < prefixComponents.length; ++i) {
            if (pathComponents[i].equals(prefixComponents[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isRoot(String path) throws InvalidPathException {
        return "/".equals(PathUtils.cleanPath(path));
    }

    public static void validatePath(String path) throws InvalidPathException {
        boolean invalid;
        boolean bl = invalid = path == null || path.isEmpty() || path.contains(" ");
        if (!OSUtils.isWindows()) {
            boolean bl2 = invalid = invalid || !path.startsWith("/");
        }
        if (invalid) {
            throw new InvalidPathException(ExceptionMessage.PATH_INVALID.getMessage(path));
        }
    }

    public static String temporaryFileName(long nonce, String path) {
        return path + String.format(TEMPORARY_SUFFIX_FORMAT, nonce);
    }

    public static String getPermanentFileName(String path) {
        if (PathUtils.isTemporaryFileName(path)) {
            return path.substring(0, path.length() - TEMPORARY_SUFFIX_LENGTH);
        }
        return path;
    }

    public static boolean isTemporaryFileName(String path) {
        return path.matches("^.*\\.alluxio\\.0x[0-9A-F]{16}\\.tmp$");
    }

    public static String uniqPath() {
        StackTraceElement caller = new Throwable().getStackTrace()[1];
        long time = System.nanoTime();
        return "/" + caller.getClassName() + "/" + caller.getMethodName() + "/" + time;
    }

    public static String normalizePath(String path, String separator) {
        return path.endsWith(separator) ? path : path + separator;
    }

    private PathUtils() {
    }
}

