/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.wire.BlockLocation;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class BlockInfo
implements Serializable {
    private static final long serialVersionUID = 5646834366222004646L;
    private long mBlockId;
    private long mLength;
    private ArrayList<BlockLocation> mLocations = new ArrayList();

    public BlockInfo() {
    }

    protected BlockInfo(alluxio.thrift.BlockInfo blockInfo) {
        this.mBlockId = blockInfo.getBlockId();
        this.mLength = blockInfo.getLength();
        this.mLocations = new ArrayList();
        for (alluxio.thrift.BlockLocation location : blockInfo.getLocations()) {
            this.mLocations.add(new BlockLocation(location));
        }
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public long getLength() {
        return this.mLength;
    }

    public List<BlockLocation> getLocations() {
        return this.mLocations;
    }

    public BlockInfo setBlockId(long blockId) {
        this.mBlockId = blockId;
        return this;
    }

    public BlockInfo setLength(long length) {
        this.mLength = length;
        return this;
    }

    public BlockInfo setLocations(List<BlockLocation> locations) {
        Preconditions.checkNotNull(locations);
        this.mLocations = new ArrayList<BlockLocation>(locations);
        return this;
    }

    protected alluxio.thrift.BlockInfo toThrift() {
        ArrayList<alluxio.thrift.BlockLocation> locations = new ArrayList<alluxio.thrift.BlockLocation>();
        for (BlockLocation location : this.mLocations) {
            locations.add(location.toThrift());
        }
        return new alluxio.thrift.BlockInfo(this.mBlockId, this.mLength, locations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockInfo)) {
            return false;
        }
        BlockInfo that = (BlockInfo)o;
        return this.mBlockId == that.mBlockId && this.mLength == that.mLength && this.mLocations.equals(that.mLocations);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mBlockId, this.mLength, this.mLocations});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", this.mBlockId).add("length", this.mLength).add("locations", this.mLocations).toString();
    }
}

