/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.wire.WorkerNetAddress;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class BlockLocation
implements Serializable {
    private static final long serialVersionUID = 9017017197104411532L;
    private long mWorkerId;
    private WorkerNetAddress mWorkerAddress = new WorkerNetAddress();
    private String mTierAlias = "";

    public BlockLocation() {
    }

    protected BlockLocation(alluxio.thrift.BlockLocation blockLocation) {
        this.mWorkerId = blockLocation.getWorkerId();
        this.mWorkerAddress = new WorkerNetAddress(blockLocation.getWorkerAddress());
        this.mTierAlias = blockLocation.getTierAlias();
    }

    public long getWorkerId() {
        return this.mWorkerId;
    }

    public WorkerNetAddress getWorkerAddress() {
        return this.mWorkerAddress;
    }

    public String getTierAlias() {
        return this.mTierAlias;
    }

    public BlockLocation setWorkerId(long workerId) {
        this.mWorkerId = workerId;
        return this;
    }

    public BlockLocation setWorkerAddress(WorkerNetAddress workerAddress) {
        Preconditions.checkNotNull((Object)workerAddress);
        this.mWorkerAddress = workerAddress;
        return this;
    }

    public BlockLocation setTierAlias(String tierAlias) {
        Preconditions.checkNotNull((Object)tierAlias);
        this.mTierAlias = tierAlias;
        return this;
    }

    protected alluxio.thrift.BlockLocation toThrift() {
        return new alluxio.thrift.BlockLocation(this.mWorkerId, this.mWorkerAddress.toThrift(), this.mTierAlias);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockLocation)) {
            return false;
        }
        BlockLocation that = (BlockLocation)o;
        return this.mWorkerId == that.mWorkerId && this.mWorkerAddress.equals(that.mWorkerAddress) && this.mTierAlias.equals(that.mTierAlias);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mWorkerId, this.mWorkerAddress, this.mTierAlias});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("workerId", this.mWorkerId).add("address", (Object)this.mWorkerAddress).add("tierAlias", (Object)this.mTierAlias).toString();
    }
}

