/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.wire.JobConfInfo;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CommandLineJobInfo
implements Serializable {
    private static final long serialVersionUID = 1058314411139470750L;
    private String mCommand = "";
    private JobConfInfo mConf = new JobConfInfo();

    public CommandLineJobInfo() {
    }

    protected CommandLineJobInfo(alluxio.thrift.CommandLineJobInfo commandLineJobInfo) {
        this.mCommand = commandLineJobInfo.getCommand();
        this.mConf = new JobConfInfo(commandLineJobInfo.getConf());
    }

    public String getCommand() {
        return this.mCommand;
    }

    public JobConfInfo getConf() {
        return this.mConf;
    }

    public CommandLineJobInfo setCommand(String command) {
        Preconditions.checkNotNull((Object)command);
        this.mCommand = command;
        return this;
    }

    public CommandLineJobInfo setConf(JobConfInfo conf) {
        Preconditions.checkNotNull((Object)conf);
        this.mConf = conf;
        return this;
    }

    protected alluxio.thrift.CommandLineJobInfo toThrift() {
        return new alluxio.thrift.CommandLineJobInfo(this.mCommand, this.mConf.toThrift());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommandLineJobInfo)) {
            return false;
        }
        CommandLineJobInfo that = (CommandLineJobInfo)o;
        return this.mCommand.equals(that.mCommand) && this.mConf.equals(that.mConf);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mCommand, this.mConf});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("command", (Object)this.mCommand).add("conf", (Object)this.mConf).toString();
    }
}

