/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.wire.FileBlockInfo;
import alluxio.wire.ThriftUtils;
import alluxio.wire.TtlAction;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class FileInfo
implements Serializable {
    private static final long serialVersionUID = 7119966306934831779L;
    private long mFileId;
    private String mName = "";
    private String mPath = "";
    private String mUfsPath = "";
    private long mLength;
    private long mBlockSizeBytes;
    private long mCreationTimeMs;
    private boolean mCompleted;
    private boolean mFolder;
    private boolean mPinned;
    private boolean mCacheable;
    private boolean mPersisted;
    private ArrayList<Long> mBlockIds = new ArrayList();
    private int mInMemoryPercentage;
    private long mLastModificationTimeMs;
    private long mTtl;
    private TtlAction mTtlAction;
    private String mOwner = "";
    private String mGroup = "";
    private int mMode;
    private String mPersistenceState = "";
    private boolean mMountPoint;
    private ArrayList<FileBlockInfo> mFileBlockInfos = new ArrayList();

    public FileInfo() {
    }

    protected FileInfo(alluxio.thrift.FileInfo fileInfo) {
        this.mFileId = fileInfo.getFileId();
        this.mName = fileInfo.getName();
        this.mPath = fileInfo.getPath();
        this.mUfsPath = fileInfo.getUfsPath();
        this.mLength = fileInfo.getLength();
        this.mBlockSizeBytes = fileInfo.getBlockSizeBytes();
        this.mCreationTimeMs = fileInfo.getCreationTimeMs();
        this.mCompleted = fileInfo.isCompleted();
        this.mFolder = fileInfo.isFolder();
        this.mPinned = fileInfo.isPinned();
        this.mCacheable = fileInfo.isCacheable();
        this.mPersisted = fileInfo.isPersisted();
        this.mBlockIds = new ArrayList<Long>(fileInfo.getBlockIds());
        this.mInMemoryPercentage = fileInfo.getInMemoryPercentage();
        this.mLastModificationTimeMs = fileInfo.getLastModificationTimeMs();
        this.mTtl = fileInfo.getTtl();
        this.mTtlAction = ThriftUtils.fromThrift(fileInfo.getTtlAction());
        this.mOwner = fileInfo.getOwner();
        this.mGroup = fileInfo.getGroup();
        this.mMode = fileInfo.getMode();
        this.mPersistenceState = fileInfo.getPersistenceState();
        this.mMountPoint = fileInfo.isMountPoint();
        this.mFileBlockInfos = new ArrayList();
        if (fileInfo.getFileBlockInfos() != null) {
            for (alluxio.thrift.FileBlockInfo fileBlockInfo : fileInfo.getFileBlockInfos()) {
                this.mFileBlockInfos.add(new FileBlockInfo(fileBlockInfo));
            }
        }
    }

    public long getFileId() {
        return this.mFileId;
    }

    public String getName() {
        return this.mName;
    }

    public String getPath() {
        return this.mPath;
    }

    public String getUfsPath() {
        return this.mUfsPath;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getBlockSizeBytes() {
        return this.mBlockSizeBytes;
    }

    public long getCreationTimeMs() {
        return this.mCreationTimeMs;
    }

    public boolean isCompleted() {
        return this.mCompleted;
    }

    public boolean isFolder() {
        return this.mFolder;
    }

    public boolean isPinned() {
        return this.mPinned;
    }

    public boolean isCacheable() {
        return this.mCacheable;
    }

    public boolean isPersisted() {
        return this.mPersisted;
    }

    public List<Long> getBlockIds() {
        return this.mBlockIds;
    }

    public int getInMemoryPercentage() {
        return this.mInMemoryPercentage;
    }

    public long getLastModificationTimeMs() {
        return this.mLastModificationTimeMs;
    }

    public long getTtl() {
        return this.mTtl;
    }

    public TtlAction getTtlAction() {
        return this.mTtlAction;
    }

    public String getOwner() {
        return this.mOwner;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public int getMode() {
        return this.mMode;
    }

    public String getPersistenceState() {
        return this.mPersistenceState;
    }

    public boolean isMountPoint() {
        return this.mMountPoint;
    }

    public List<FileBlockInfo> getFileBlockInfos() {
        return this.mFileBlockInfos;
    }

    public FileInfo setFileId(long fileId) {
        this.mFileId = fileId;
        return this;
    }

    public FileInfo setName(String name) {
        Preconditions.checkNotNull((Object)name);
        this.mName = name;
        return this;
    }

    public FileInfo setPath(String path) {
        Preconditions.checkNotNull((Object)path);
        this.mPath = path;
        return this;
    }

    public FileInfo setUfsPath(String ufsPath) {
        Preconditions.checkNotNull((Object)ufsPath);
        this.mUfsPath = ufsPath;
        return this;
    }

    public FileInfo setLength(long length) {
        this.mLength = length;
        return this;
    }

    public FileInfo setBlockSizeBytes(long blockSizeBytes) {
        this.mBlockSizeBytes = blockSizeBytes;
        return this;
    }

    public FileInfo setCreationTimeMs(long creationTimeMs) {
        this.mCreationTimeMs = creationTimeMs;
        return this;
    }

    public FileInfo setCompleted(boolean completed) {
        this.mCompleted = completed;
        return this;
    }

    public FileInfo setFolder(boolean folder) {
        this.mFolder = folder;
        return this;
    }

    public FileInfo setPinned(boolean pinned) {
        this.mPinned = pinned;
        return this;
    }

    public FileInfo setCacheable(boolean cacheable) {
        this.mCacheable = cacheable;
        return this;
    }

    public FileInfo setPersisted(boolean persisted) {
        this.mPersisted = persisted;
        return this;
    }

    public FileInfo setBlockIds(List<Long> blockIds) {
        Preconditions.checkNotNull(blockIds);
        this.mBlockIds = new ArrayList<Long>(blockIds);
        return this;
    }

    public FileInfo setInMemoryPercentage(int inMemoryPercentage) {
        this.mInMemoryPercentage = inMemoryPercentage;
        return this;
    }

    public FileInfo setLastModificationTimeMs(long lastModificationTimeMs) {
        this.mLastModificationTimeMs = lastModificationTimeMs;
        return this;
    }

    public FileInfo setTtl(long ttl) {
        this.mTtl = ttl;
        return this;
    }

    public FileInfo setTtlAction(TtlAction ttlAction) {
        this.mTtlAction = ttlAction;
        return this;
    }

    public FileInfo setOwner(String owner) {
        Preconditions.checkNotNull((Object)owner);
        this.mOwner = owner;
        return this;
    }

    public FileInfo setGroup(String group) {
        Preconditions.checkNotNull((Object)group);
        this.mGroup = group;
        return this;
    }

    public FileInfo setMode(int mode) {
        this.mMode = mode;
        return this;
    }

    public FileInfo setPersistenceState(String persistenceState) {
        Preconditions.checkNotNull((Object)persistenceState);
        this.mPersistenceState = persistenceState;
        return this;
    }

    public FileInfo setMountPoint(boolean mountPoint) {
        this.mMountPoint = mountPoint;
        return this;
    }

    public FileInfo setFileBlockInfos(List<FileBlockInfo> fileBlockInfos) {
        this.mFileBlockInfos = new ArrayList<FileBlockInfo>(fileBlockInfos);
        return this;
    }

    protected alluxio.thrift.FileInfo toThrift() {
        ArrayList<alluxio.thrift.FileBlockInfo> fileBlockInfos = new ArrayList<alluxio.thrift.FileBlockInfo>();
        for (FileBlockInfo fileBlockInfo : this.mFileBlockInfos) {
            fileBlockInfos.add(fileBlockInfo.toThrift());
        }
        alluxio.thrift.FileInfo info = new alluxio.thrift.FileInfo(this.mFileId, this.mName, this.mPath, this.mUfsPath, this.mLength, this.mBlockSizeBytes, this.mCreationTimeMs, this.mCompleted, this.mFolder, this.mPinned, this.mCacheable, this.mPersisted, this.mBlockIds, this.mInMemoryPercentage, this.mLastModificationTimeMs, this.mTtl, this.mOwner, this.mGroup, this.mMode, this.mPersistenceState, this.mMountPoint, fileBlockInfos, ThriftUtils.toThrift(this.mTtlAction));
        return info;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileInfo)) {
            return false;
        }
        FileInfo that = (FileInfo)o;
        return this.mFileId == that.mFileId && this.mName.equals(that.mName) && this.mPath.equals(that.mPath) && this.mUfsPath.equals(that.mUfsPath) && this.mLength == that.mLength && this.mBlockSizeBytes == that.mBlockSizeBytes && this.mCreationTimeMs == that.mCreationTimeMs && this.mCompleted == that.mCompleted && this.mFolder == that.mFolder && this.mPinned == that.mPinned && this.mCacheable == that.mCacheable && this.mPersisted == that.mPersisted && this.mBlockIds.equals(that.mBlockIds) && this.mInMemoryPercentage == that.mInMemoryPercentage && this.mLastModificationTimeMs == that.mLastModificationTimeMs && this.mTtl == that.mTtl && this.mOwner.equals(that.mOwner) && this.mGroup.equals(that.mGroup) && this.mMode == that.mMode && this.mPersistenceState.equals(that.mPersistenceState) && this.mMountPoint == that.mMountPoint && this.mFileBlockInfos.equals(that.mFileBlockInfos) && this.mTtlAction == that.mTtlAction;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mFileId, this.mName, this.mPath, this.mUfsPath, this.mLength, this.mBlockSizeBytes, this.mCreationTimeMs, this.mCompleted, this.mFolder, this.mPinned, this.mCacheable, this.mPersisted, this.mBlockIds, this.mInMemoryPercentage, this.mLastModificationTimeMs, this.mTtl, this.mOwner, this.mGroup, this.mMode, this.mPersistenceState, this.mMountPoint, this.mFileBlockInfos, this.mTtlAction});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("fileId", this.mFileId).add("name", (Object)this.mName).add("path", (Object)this.mPath).add("ufsPath", (Object)this.mUfsPath).add("length", this.mLength).add("blockSizeBytes", this.mBlockSizeBytes).add("creationTimeMs", this.mCreationTimeMs).add("completed", this.mCompleted).add("folder", this.mFolder).add("pinned", this.mPinned).add("cacheable", this.mCacheable).add("persisted", this.mPersisted).add("blockIds", this.mBlockIds).add("inMemoryPercentage", this.mInMemoryPercentage).add("lastModificationTimesMs", this.mLastModificationTimeMs).add("ttl", this.mTtl).add("ttlAction", (Object)this.mTtlAction).add("owner", (Object)this.mOwner).add("group", (Object)this.mGroup).add("mode", this.mMode).add("persistenceState", (Object)this.mPersistenceState).add("mountPoint", this.mMountPoint).add("fileBlockInfos", this.mFileBlockInfos).toString();
    }
}

