/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.wire.CommandLineJobInfo;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class LineageInfo
implements Serializable {
    private static final long serialVersionUID = -6407439859190160616L;
    private long mId;
    private ArrayList<String> mInputFiles = new ArrayList();
    private ArrayList<String> mOutputFiles = new ArrayList();
    private CommandLineJobInfo mJob = new CommandLineJobInfo();
    private long mCreationTimeMs;
    private ArrayList<Long> mParents = new ArrayList();
    private ArrayList<Long> mChildren = new ArrayList();

    public LineageInfo() {
    }

    protected LineageInfo(alluxio.thrift.LineageInfo lineageInfo) {
        this.mId = lineageInfo.getId();
        this.mInputFiles = new ArrayList<String>(lineageInfo.getInputFiles());
        this.mOutputFiles = new ArrayList<String>(lineageInfo.getOutputFiles());
        this.mJob = new CommandLineJobInfo(lineageInfo.getJob());
        this.mCreationTimeMs = lineageInfo.getCreationTimeMs();
        this.mParents = new ArrayList<Long>(lineageInfo.getParents());
        this.mChildren = new ArrayList<Long>(lineageInfo.getChildren());
    }

    public long getId() {
        return this.mId;
    }

    public List<String> getInputFiles() {
        return this.mInputFiles;
    }

    public List<String> getOutputFiles() {
        return this.mOutputFiles;
    }

    public CommandLineJobInfo getJob() {
        return this.mJob;
    }

    public long getCreationTimeMs() {
        return this.mCreationTimeMs;
    }

    public List<Long> getParents() {
        return this.mParents;
    }

    public List<Long> getChildren() {
        return this.mChildren;
    }

    public LineageInfo setId(long id) {
        this.mId = id;
        return this;
    }

    public LineageInfo setInputFiles(List<String> inputFiles) {
        Preconditions.checkNotNull(inputFiles);
        this.mInputFiles = new ArrayList<String>(inputFiles);
        return this;
    }

    public LineageInfo setOutputFiles(List<String> outputFiles) {
        Preconditions.checkNotNull(outputFiles);
        this.mOutputFiles = new ArrayList<String>(outputFiles);
        return this;
    }

    public LineageInfo setJob(CommandLineJobInfo job) {
        Preconditions.checkNotNull((Object)job);
        this.mJob = job;
        return this;
    }

    public LineageInfo setCreationTimeMs(long creationTimeMs) {
        this.mCreationTimeMs = creationTimeMs;
        return this;
    }

    public LineageInfo setParents(List<Long> parents) {
        Preconditions.checkNotNull(parents);
        this.mParents = new ArrayList<Long>(parents);
        return this;
    }

    public LineageInfo setChildren(List<Long> children) {
        Preconditions.checkNotNull(children);
        this.mChildren = new ArrayList<Long>(children);
        return this;
    }

    protected alluxio.thrift.LineageInfo toThrift() {
        return new alluxio.thrift.LineageInfo(this.mId, this.mInputFiles, this.mOutputFiles, this.mJob.toThrift(), this.mCreationTimeMs, this.mParents, this.mChildren);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LineageInfo)) {
            return false;
        }
        LineageInfo that = (LineageInfo)o;
        return this.mId == that.mId && this.mInputFiles.equals(that.mInputFiles) && this.mOutputFiles.equals(that.mOutputFiles) && this.mJob.equals(that.mJob) && this.mCreationTimeMs == that.mCreationTimeMs && this.mParents.equals(that.mParents) && this.mChildren.equals(that.mChildren);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mId, this.mInputFiles, this.mOutputFiles, this.mJob, this.mCreationTimeMs, this.mParents, this.mChildren});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", this.mId).add("inputFiles", this.mInputFiles).add("outputFiles", this.mOutputFiles).add("job", (Object)this.mJob).add("creationTimeMs", this.mCreationTimeMs).add("parents", this.mParents).add("children", this.mChildren).toString();
    }
}

