/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class LockBlockResult
implements Serializable {
    private static final long serialVersionUID = -2217323649674837526L;
    private long mLockId;
    private String mBlockPath = "";

    public LockBlockResult() {
    }

    protected LockBlockResult(alluxio.thrift.LockBlockResult lockBlockResult) {
        this.mLockId = lockBlockResult.getLockId();
        this.mBlockPath = lockBlockResult.getBlockPath();
    }

    public long getLockId() {
        return this.mLockId;
    }

    public String getBlockPath() {
        return this.mBlockPath;
    }

    public LockBlockResult setLockId(long lockId) {
        this.mLockId = lockId;
        return this;
    }

    public LockBlockResult setBlockPath(String blockPath) {
        Preconditions.checkNotNull((Object)blockPath);
        this.mBlockPath = blockPath;
        return this;
    }

    protected alluxio.thrift.LockBlockResult toThrift() {
        return new alluxio.thrift.LockBlockResult(this.mLockId, this.mBlockPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LockBlockResult)) {
            return false;
        }
        LockBlockResult that = (LockBlockResult)o;
        return this.mLockId == that.mLockId && this.mBlockPath.equals(that.mBlockPath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mLockId, this.mBlockPath});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("lockId", this.mLockId).add("blockPath", (Object)this.mBlockPath).toString();
    }
}

