/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.wire.WorkerNetAddress;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class WorkerInfo
implements Serializable {
    private static final long serialVersionUID = -454711814438216780L;
    private long mId;
    private WorkerNetAddress mAddress = new WorkerNetAddress();
    private int mLastContactSec;
    private String mState = "";
    private long mCapacityBytes;
    private long mUsedBytes;
    private long mStartTimeMs;

    public WorkerInfo() {
    }

    protected WorkerInfo(alluxio.thrift.WorkerInfo workerInfo) {
        this.mId = workerInfo.getId();
        this.mAddress = new WorkerNetAddress(workerInfo.getAddress());
        this.mLastContactSec = workerInfo.getLastContactSec();
        this.mState = workerInfo.getState();
        this.mCapacityBytes = workerInfo.getCapacityBytes();
        this.mUsedBytes = workerInfo.getUsedBytes();
        this.mStartTimeMs = workerInfo.getStartTimeMs();
    }

    public long getId() {
        return this.mId;
    }

    public WorkerNetAddress getAddress() {
        return this.mAddress;
    }

    public int getLastContactSec() {
        return this.mLastContactSec;
    }

    public String getState() {
        return this.mState;
    }

    public long getCapacityBytes() {
        return this.mCapacityBytes;
    }

    public long getUsedBytes() {
        return this.mUsedBytes;
    }

    public long getStartTimeMs() {
        return this.mStartTimeMs;
    }

    public WorkerInfo setId(long id) {
        this.mId = id;
        return this;
    }

    public WorkerInfo setAddress(WorkerNetAddress address) {
        Preconditions.checkNotNull((Object)address);
        this.mAddress = address;
        return this;
    }

    public WorkerInfo setLastContactSec(int lastContactSec) {
        this.mLastContactSec = lastContactSec;
        return this;
    }

    public WorkerInfo setState(String state) {
        Preconditions.checkNotNull((Object)state);
        this.mState = state;
        return this;
    }

    public WorkerInfo setCapacityBytes(long capacityBytes) {
        this.mCapacityBytes = capacityBytes;
        return this;
    }

    public WorkerInfo setUsedBytes(long usedBytes) {
        this.mUsedBytes = usedBytes;
        return this;
    }

    public WorkerInfo setStartTimeMs(long startTimeMs) {
        this.mStartTimeMs = startTimeMs;
        return this;
    }

    protected alluxio.thrift.WorkerInfo toThrift() {
        return new alluxio.thrift.WorkerInfo(this.mId, this.mAddress.toThrift(), this.mLastContactSec, this.mState, this.mCapacityBytes, this.mUsedBytes, this.mStartTimeMs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkerInfo)) {
            return false;
        }
        WorkerInfo that = (WorkerInfo)o;
        return this.mId == that.mId && this.mAddress.equals(that.mAddress) && this.mLastContactSec == that.mLastContactSec && this.mState.equals(that.mState) && this.mCapacityBytes == that.mCapacityBytes && this.mUsedBytes == that.mUsedBytes && this.mStartTimeMs == that.mStartTimeMs;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mId, this.mAddress, this.mLastContactSec, this.mState, this.mCapacityBytes, this.mUsedBytes, this.mStartTimeMs});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", this.mId).add("address", (Object)this.mAddress).add("lastContactSec", this.mLastContactSec).add("state", (Object)this.mState).add("capacityBytes", this.mCapacityBytes).add("usedBytes", this.mUsedBytes).add("startTimeMs", this.mStartTimeMs).toString();
    }
}

