/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class WorkerNetAddress
implements Serializable {
    private static final long serialVersionUID = 5822347646342091434L;
    private String mHost = "";
    private int mRpcPort;
    private int mDataPort;
    private int mWebPort;

    public WorkerNetAddress() {
    }

    protected WorkerNetAddress(alluxio.thrift.WorkerNetAddress workerNetAddress) {
        this.mHost = workerNetAddress.getHost();
        this.mRpcPort = workerNetAddress.getRpcPort();
        this.mDataPort = workerNetAddress.getDataPort();
        this.mWebPort = workerNetAddress.getWebPort();
    }

    public String getHost() {
        return this.mHost;
    }

    public int getRpcPort() {
        return this.mRpcPort;
    }

    public int getDataPort() {
        return this.mDataPort;
    }

    public int getWebPort() {
        return this.mWebPort;
    }

    public WorkerNetAddress setHost(String host) {
        Preconditions.checkNotNull((Object)host);
        this.mHost = host;
        return this;
    }

    public WorkerNetAddress setRpcPort(int rpcPort) {
        this.mRpcPort = rpcPort;
        return this;
    }

    public WorkerNetAddress setDataPort(int dataPort) {
        this.mDataPort = dataPort;
        return this;
    }

    public WorkerNetAddress setWebPort(int webPort) {
        this.mWebPort = webPort;
        return this;
    }

    protected alluxio.thrift.WorkerNetAddress toThrift() {
        return new alluxio.thrift.WorkerNetAddress(this.mHost, this.mRpcPort, this.mDataPort, this.mWebPort);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkerNetAddress)) {
            return false;
        }
        WorkerNetAddress that = (WorkerNetAddress)o;
        return this.mHost.equals(that.mHost) && this.mRpcPort == that.mRpcPort && this.mDataPort == that.mDataPort && this.mWebPort == that.mWebPort;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mHost, this.mDataPort, this.mRpcPort, this.mWebPort});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("host", (Object)this.mHost).add("rpcPort", this.mRpcPort).add("dataPort", this.mDataPort).add("webPort", this.mWebPort).toString();
    }
}

