/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker;

import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCResponse;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class DataServerMessage {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final int HEADER_PREFIX_LENGTH = 12;
    private static final int REQUEST_HEADER_LENGTH = 52;
    private static final int RESPONSE_HEADER_LENGTH = 38;
    private static final int ERROR_RESPONSE_HEADER_LENGTH = 14;
    private final boolean mToSendData;
    private final RPCMessage.Type mMessageType;
    private boolean mIsMessageReady;
    private ByteBuffer mHeader;
    private long mBlockId;
    private long mOffset;
    private long mLength;
    private RPCResponse.Status mStatus;
    private long mLockId = -1L;
    private long mSessionId;
    private ByteBuffer mData = null;

    public static DataServerMessage createBlockRequestMessage() {
        DataServerMessage ret = new DataServerMessage(false, RPCMessage.Type.RPC_BLOCK_READ_REQUEST);
        ret.mHeader = ByteBuffer.allocate(52);
        return ret;
    }

    public static DataServerMessage createBlockRequestMessage(long blockId, long offset, long len, long lockId, long sessionId) {
        DataServerMessage ret = new DataServerMessage(true, RPCMessage.Type.RPC_BLOCK_READ_REQUEST);
        ret.mHeader = ByteBuffer.allocate(52);
        ret.mBlockId = blockId;
        ret.mOffset = offset;
        ret.mLength = len;
        ret.mLockId = lockId;
        ret.mSessionId = sessionId;
        ret.generateHeader();
        ret.mData = ByteBuffer.allocate(0);
        ret.mIsMessageReady = true;
        return ret;
    }

    public static DataServerMessage createBlockResponseMessage(boolean toSend, long blockId, ByteBuffer data) {
        return DataServerMessage.createBlockResponseMessage(toSend, blockId, 0L, -1L, data);
    }

    public static DataServerMessage createBlockResponseMessage(boolean toSend, long blockId, long offset, long len, ByteBuffer data) {
        DataServerMessage ret = new DataServerMessage(toSend, RPCMessage.Type.RPC_BLOCK_READ_RESPONSE);
        if (toSend) {
            if (data != null) {
                ret.mHeader = ByteBuffer.allocate(38);
                ret.mBlockId = blockId;
                ret.mOffset = offset;
                ret.mLength = len;
                ret.mStatus = RPCResponse.Status.SUCCESS;
                ret.mData = data;
                ret.mIsMessageReady = true;
                ret.generateHeader();
            } else {
                ret.mBlockId = blockId;
                ret.mLength = 0L;
                ret.mHeader = ByteBuffer.allocate(38);
                ret.mData = ByteBuffer.allocate(0);
                ret.mIsMessageReady = true;
                ret.mStatus = RPCResponse.Status.FILE_DNE;
                LOG.error("The file is not here! blockId:{}", (Object)blockId);
                ret.generateHeader();
            }
        } else {
            ret.mHeader = ByteBuffer.allocate(38);
            ret.mData = null;
        }
        return ret;
    }

    private DataServerMessage(boolean isToSendData, RPCMessage.Type msgType) {
        this.mToSendData = isToSendData;
        this.mMessageType = msgType;
        this.mIsMessageReady = false;
    }

    public void checkReady() {
        Preconditions.checkState((boolean)this.mIsMessageReady, (Object)"Message is not ready.");
    }

    public void close() {
    }

    public boolean finishSending() {
        this.isSend(true);
        return this.mHeader.remaining() == 0 && this.mData.remaining() == 0;
    }

    private void generateHeader() {
        this.mHeader.clear();
        if (this.mMessageType == RPCMessage.Type.RPC_BLOCK_READ_REQUEST) {
            this.mHeader.putLong(52L);
        } else {
            this.mHeader.putLong(38L + this.mLength);
        }
        this.mHeader.putInt(this.mMessageType.getId());
        this.mHeader.putLong(this.mBlockId);
        this.mHeader.putLong(this.mOffset);
        this.mHeader.putLong(this.mLength);
        if (this.mMessageType == RPCMessage.Type.RPC_BLOCK_READ_REQUEST) {
            this.mHeader.putLong(this.mLockId);
            this.mHeader.putLong(this.mSessionId);
        } else if (this.mMessageType == RPCMessage.Type.RPC_BLOCK_READ_RESPONSE) {
            this.mHeader.putShort(this.mStatus.getId());
        }
        this.mHeader.flip();
    }

    public long getBlockId() {
        this.checkReady();
        return this.mBlockId;
    }

    public long getLength() {
        this.checkReady();
        return this.mLength;
    }

    public long getLockId() {
        return this.mLockId;
    }

    public long getOffset() {
        this.checkReady();
        return this.mOffset;
    }

    public long getSessionId() {
        this.checkReady();
        return this.mSessionId;
    }

    public RPCResponse.Status getStatus() {
        this.checkReady();
        return this.mStatus;
    }

    public ByteBuffer getReadOnlyData() {
        this.checkReady();
        ByteBuffer ret = this.mData.asReadOnlyBuffer();
        ret.flip();
        return ret;
    }

    public boolean isMessageReady() {
        return this.mIsMessageReady;
    }

    private void isSend(boolean isSend) {
        if (this.mToSendData != isSend) {
            if (this.mToSendData) {
                throw new RuntimeException("Try to recv on send message");
            }
            throw new RuntimeException("Try to send on recv message");
        }
    }

    public int recv(SocketChannel socketChannel) throws IOException {
        int numRead;
        this.isSend(false);
        if (this.mHeader.remaining() > 0) {
            numRead = socketChannel.read(this.mHeader);
            if (numRead == -1 && this.mHeader.position() >= 14) {
                this.mHeader.flip();
                this.mHeader.getLong();
                int receivedMessageType = this.mHeader.getInt();
                if (receivedMessageType == RPCMessage.Type.RPC_ERROR_RESPONSE.getId()) {
                    this.mStatus = RPCResponse.Status.fromShort(this.mHeader.getShort());
                    throw new IOException(this.mStatus.getMessage());
                }
                throw new IOException("Received an unexpected message type: " + receivedMessageType);
            }
            if (this.mHeader.remaining() == 0) {
                this.mHeader.flip();
                this.mHeader.getLong();
                int receivedMessageType = this.mHeader.getInt();
                Preconditions.checkState((this.mMessageType.getId() == receivedMessageType ? 1 : 0) != 0, (Object)("Unexpected message type (" + receivedMessageType + ") received. expected: " + this.mMessageType.getId()));
                this.mBlockId = this.mHeader.getLong();
                this.mOffset = this.mHeader.getLong();
                this.mLength = this.mHeader.getLong();
                if (this.mMessageType.getId() == RPCMessage.Type.RPC_BLOCK_READ_REQUEST.getId()) {
                    this.mLockId = this.mHeader.getLong();
                    this.mSessionId = this.mHeader.getLong();
                }
                Preconditions.checkState((this.mLength < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)("received length is too large: " + this.mLength));
                if (this.mMessageType == RPCMessage.Type.RPC_BLOCK_READ_RESPONSE) {
                    this.mStatus = RPCResponse.Status.fromShort(this.mHeader.getShort());
                    this.mData = this.mStatus == RPCResponse.Status.SUCCESS ? ByteBuffer.allocate((int)this.mLength) : ByteBuffer.allocate(0);
                }
                LOG.info("data {}, blockId:{} offset:{} dataLength:{}", new Object[]{this.mData, this.mBlockId, this.mOffset, this.mLength});
                if (this.mMessageType == RPCMessage.Type.RPC_BLOCK_READ_REQUEST) {
                    this.mIsMessageReady = true;
                } else if (this.mMessageType == RPCMessage.Type.RPC_BLOCK_READ_RESPONSE && (this.mLength <= 0L || this.mStatus != RPCResponse.Status.SUCCESS)) {
                    this.mIsMessageReady = true;
                }
            }
        } else {
            numRead = socketChannel.read(this.mData);
            if (this.mData.remaining() == 0) {
                this.mIsMessageReady = true;
            }
        }
        return numRead;
    }

    public void send(SocketChannel socketChannel) throws IOException {
        Preconditions.checkNotNull((Object)socketChannel);
        this.isSend(true);
        socketChannel.write(this.mHeader);
        if (this.mHeader.remaining() == 0) {
            socketChannel.write(this.mData);
        }
    }

    public void setLockId(long lockId) {
        this.mLockId = lockId;
    }
}

