/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.io;

import alluxio.worker.block.io.BlockReader;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class LocalFileBlockReader
implements BlockReader {
    private final String mFilePath;
    private final RandomAccessFile mLocalFile;
    private final FileChannel mLocalFileChannel;
    private final Closer mCloser = Closer.create();
    private final long mFileSize;

    public LocalFileBlockReader(String path) throws IOException {
        this.mFilePath = (String)Preconditions.checkNotNull((Object)path);
        this.mLocalFile = (RandomAccessFile)this.mCloser.register((Closeable)new RandomAccessFile(this.mFilePath, "r"));
        this.mLocalFileChannel = (FileChannel)this.mCloser.register((Closeable)this.mLocalFile.getChannel());
        this.mFileSize = this.mLocalFile.length();
    }

    @Override
    public ReadableByteChannel getChannel() {
        return this.mLocalFileChannel;
    }

    @Override
    public long getLength() {
        return this.mFileSize;
    }

    @Override
    public ByteBuffer read(long offset, long length) throws IOException {
        Preconditions.checkArgument((offset + length <= this.mFileSize ? 1 : 0) != 0, (String)"offset=%s, length=%s, exceeding fileSize=%s", (Object[])new Object[]{offset, length, this.mFileSize});
        if (length == -1L) {
            length = this.mFileSize - offset;
        }
        return this.mLocalFileChannel.map(FileChannel.MapMode.READ_ONLY, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.mCloser.close();
    }
}

