/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.io;

import alluxio.util.io.BufferUtils;
import alluxio.worker.block.io.BlockWriter;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class LocalFileBlockWriter
implements BlockWriter {
    private final String mFilePath;
    private final RandomAccessFile mLocalFile;
    private final FileChannel mLocalFileChannel;
    private final Closer mCloser = Closer.create();

    public LocalFileBlockWriter(String path) throws IOException {
        this.mFilePath = (String)Preconditions.checkNotNull((Object)path);
        this.mLocalFile = (RandomAccessFile)this.mCloser.register((Closeable)new RandomAccessFile(this.mFilePath, "rw"));
        this.mLocalFileChannel = (FileChannel)this.mCloser.register((Closeable)this.mLocalFile.getChannel());
    }

    @Override
    public GatheringByteChannel getChannel() {
        return this.mLocalFileChannel;
    }

    @Override
    public long append(ByteBuffer inputBuf) throws IOException {
        return this.write(this.mLocalFileChannel.size(), inputBuf.duplicate());
    }

    @Override
    public void close() throws IOException {
        this.mCloser.close();
    }

    private long write(long offset, ByteBuffer inputBuf) throws IOException {
        int inputBufLength = inputBuf.limit() - inputBuf.position();
        MappedByteBuffer outputBuf = this.mLocalFileChannel.map(FileChannel.MapMode.READ_WRITE, offset, inputBufLength);
        outputBuf.put(inputBuf);
        int bytesWritten = outputBuf.limit();
        BufferUtils.cleanDirectBuffer(outputBuf);
        return bytesWritten;
    }
}

