/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.mapreduce;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LzoIndexRecordWriter
extends RecordWriter<Path, LongWritable> {
    private static final Log LOG = LogFactory.getLog(LzoIndexRecordWriter.class);
    private FSDataOutputStream outputStream;
    private final TaskAttemptContext context;
    private FileSystem fs;
    private Path inputPath;
    private Path tmpIndexPath;
    private Path realIndexPath;

    public LzoIndexRecordWriter(TaskAttemptContext taskAttemptContext) {
        this.context = taskAttemptContext;
    }

    public void write(Path path, LongWritable offset) throws IOException, InterruptedException {
        if (this.outputStream == null) {
            LOG.info((Object)("Setting up output stream to write index file for " + path));
            this.outputStream = this.setupOutputFile(path);
        }
        offset.write((DataOutput)this.outputStream);
    }

    public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        if (this.outputStream != null) {
            this.outputStream.close();
            LOG.info((Object)("In close, now renaming " + this.tmpIndexPath + " to final location " + this.realIndexPath));
            this.fs.rename(this.tmpIndexPath, this.realIndexPath);
        }
    }

    private FSDataOutputStream setupOutputFile(Path path) throws IOException {
        this.fs = path.getFileSystem(this.context.getConfiguration());
        this.inputPath = path;
        this.tmpIndexPath = path.suffix(".index.tmp");
        this.realIndexPath = path.suffix(".index");
        this.fs.delete(this.tmpIndexPath, false);
        this.fs.delete(this.realIndexPath, false);
        return this.fs.create(this.tmpIndexPath, false);
    }
}

