/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.lzo.hadoop.codec;

import java.io.IOException;
import org.anarres.lzo.LzoAlgorithm;
import org.anarres.lzo.LzoConstraint;
import org.anarres.lzo.LzoLibrary;
import org.anarres.lzo.SuppressWarnings;
import org.anarres.lzo.lzo_uintp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.Compressor;

public class LzoCompressor
implements Compressor {
    private static final Log LOG = LogFactory.getLog(LzoCompressor.class);
    private final org.anarres.lzo.LzoCompressor compressor;
    private final byte[] inputBuffer;
    private int inputBufferLen;
    private byte[] inputHoldoverBuffer;
    private int inputHoldoverBufferPos;
    private int inputHoldoverBufferLen;
    private final byte[] outputBuffer;
    private int outputBufferPos;
    private final lzo_uintp outputBufferLen = new lzo_uintp();
    private int inputByteCount;
    private int outputByteCount;
    private boolean finished;

    public LzoCompressor(CompressionStrategy strategy, int outputBufferSize) {
        this.compressor = strategy.newCompressor();
        this.inputBuffer = new byte[outputBufferSize];
        this.outputBuffer = new byte[outputBufferSize + (outputBufferSize >> 3) + 256];
        this.reset();
    }

    public LzoCompressor() {
        this(CompressionStrategy.LZO1X_1, 65536);
    }

    private void logState(String when) {
        LOG.info((Object)"\n");
        LOG.info((Object)(when + " Input buffer length=" + this.inputBufferLen + "/" + this.inputBuffer.length));
        if (this.inputHoldoverBuffer == null) {
            LOG.info((Object)(when + " Input holdover = null"));
        } else {
            LOG.info((Object)(when + " Input holdover pos=" + this.inputHoldoverBufferPos + "; length=" + this.inputHoldoverBufferLen));
        }
        LOG.info((Object)(when + " Output buffer pos=" + this.outputBufferPos + "; length=" + this.outputBufferLen + "/" + this.outputBuffer.length));
        this.testInvariants();
    }

    private boolean testInvariants() {
        if (this.inputHoldoverBuffer != null) {
            if (this.inputBufferLen != 0 && this.inputBufferLen != this.inputBuffer.length) {
                throw new IllegalStateException("Funny input buffer length " + this.inputBufferLen + " with array size " + this.inputBuffer.length + " and holdover.");
            }
            if (this.inputHoldoverBufferPos < 0) {
                throw new IllegalStateException("Using holdover buffer, but invalid holdover position " + this.inputHoldoverBufferPos);
            }
            if (this.inputHoldoverBufferLen < 0) {
                throw new IllegalStateException("Using holdover buffer, but invalid holdover length " + this.inputHoldoverBufferLen);
            }
        } else {
            if (this.inputHoldoverBufferPos != -1) {
                throw new IllegalStateException("No holdover buffer, but valid holdover position " + this.inputHoldoverBufferPos);
            }
            if (this.inputHoldoverBufferLen != -1) {
                throw new IllegalStateException("No holdover buffer, but valid holdover length " + this.inputHoldoverBufferLen);
            }
        }
        if (this.outputBufferLen.value < 0) {
            throw new IllegalStateException("Output buffer overrun pos=" + this.outputBufferPos + "; len=" + this.outputBufferLen);
        }
        return true;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException("Illegal range in buffer: Buffer length=" + b.length + ", offset=" + off + ", length=" + len);
        }
        if (this.inputHoldoverBuffer != null) {
            throw new IllegalStateException("Cannot accept input while holdover is present.");
        }
        this.inputHoldoverBuffer = b;
        this.inputHoldoverBufferPos = off;
        this.inputHoldoverBufferLen = len;
        this.compact();
        this.inputByteCount += len;
    }

    public void setDictionary(byte[] b, int off, int len) {
    }

    public boolean needsInput() {
        this.compact();
        if (this.inputHoldoverBuffer != null) {
            return false;
        }
        return this.inputBufferLen < this.inputBuffer.length;
    }

    public void finish() {
        this.finished = true;
    }

    public boolean finished() {
        assert (this.testInvariants());
        return this.finished && this.outputBufferLen.value == 0 && this.inputBufferLen == 0 && this.inputHoldoverBuffer == null;
    }

    private void compact() {
        if (this.inputHoldoverBuffer == null) {
            assert (this.testInvariants());
            return;
        }
        int remaining = this.inputBuffer.length - this.inputBufferLen;
        if (this.inputHoldoverBufferLen <= remaining) {
            System.arraycopy(this.inputHoldoverBuffer, this.inputHoldoverBufferPos, this.inputBuffer, this.inputBufferLen, this.inputHoldoverBufferLen);
            this.inputBufferLen += this.inputHoldoverBufferLen;
            this.inputHoldoverBuffer = null;
            this.inputHoldoverBufferPos = -1;
            this.inputHoldoverBufferLen = -1;
        } else if (this.inputBufferLen != 0) {
            System.arraycopy(this.inputHoldoverBuffer, this.inputHoldoverBufferPos, this.inputBuffer, this.inputBufferLen, remaining);
            this.inputBufferLen += remaining;
            this.inputHoldoverBufferPos += remaining;
            this.inputHoldoverBufferLen -= remaining;
        }
        assert (this.testInvariants());
    }

    public int compress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException("Illegal range in buffer: Buffer length=" + b.length + ", offset=" + off + ", length=" + len);
        }
        if (this.outputBufferLen.value == 0) {
            int compressBufferLen;
            int compressBufferPos;
            byte[] compressBuffer;
            if (this.inputBufferLen > 0) {
                compressBuffer = this.inputBuffer;
                compressBufferPos = 0;
                compressBufferLen = this.inputBufferLen;
                this.inputBufferLen = 0;
            } else if (this.inputHoldoverBuffer != null) {
                compressBuffer = this.inputHoldoverBuffer;
                compressBufferPos = this.inputHoldoverBufferPos;
                compressBufferLen = Math.min(this.inputBuffer.length, this.inputHoldoverBufferLen);
                assert (compressBufferLen == this.inputBuffer.length) : "Compressing less than one block of holdover.";
                this.inputHoldoverBufferPos += compressBufferLen;
                this.inputHoldoverBufferLen -= compressBufferLen;
            } else {
                throw new IllegalStateException("compress() called with no input.");
            }
            this.compact();
            this.outputBufferPos = 0;
            this.outputBufferLen.value = this.outputBuffer.length;
            try {
                int code = this.compressor.compress(compressBuffer, compressBufferPos, compressBufferLen, this.outputBuffer, this.outputBufferPos, this.outputBufferLen);
                if (code != 0) {
                    this.logState("LZO error: " + code);
                    throw new IllegalArgumentException(this.compressor.toErrorString(code));
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.logState("IndexOutOfBoundsException: " + e);
                throw new IOException(e);
            }
        }
        len = Math.min(len, this.outputBufferLen.value);
        System.arraycopy(this.outputBuffer, this.outputBufferPos, b, off, len);
        this.outputBufferPos += len;
        this.outputBufferLen.value -= len;
        this.outputByteCount += len;
        return len;
    }

    private void _reset() {
        this.inputByteCount = 0;
        this.outputByteCount = 0;
        this.inputBufferLen = 0;
        this.inputHoldoverBuffer = null;
        this.inputHoldoverBufferPos = -1;
        this.inputHoldoverBufferLen = -1;
        this.outputBufferPos = 0;
        this.outputBufferLen.value = 0;
        this.finished = false;
    }

    public void reset() {
        this._reset();
    }

    public synchronized void reinit(Configuration conf) {
        this._reset();
    }

    public synchronized long getBytesRead() {
        return this.inputByteCount;
    }

    public long getBytesWritten() {
        return this.outputByteCount;
    }

    public void end() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompressionStrategy {
        LZO1(LzoAlgorithm.LZO1),
        LZO1_99(LzoAlgorithm.LZO1, LzoConstraint.COMPRESSION),
        LZO1A(LzoAlgorithm.LZO1),
        LZO1A_99(LzoAlgorithm.LZO1, LzoConstraint.COMPRESSION),
        LZO1B(LzoAlgorithm.LZO1),
        LZO1B_BEST_COMPRESSION(LzoAlgorithm.LZO1, LzoConstraint.COMPRESSION),
        LZO1B_BEST_SPEED(LzoAlgorithm.LZO1, LzoConstraint.SPEED),
        LZO1B_1(LzoAlgorithm.LZO1B),
        LZO1B_2(LzoAlgorithm.LZO1B),
        LZO1B_3(LzoAlgorithm.LZO1B),
        LZO1B_4(LzoAlgorithm.LZO1B),
        LZO1B_5(LzoAlgorithm.LZO1B),
        LZO1B_6(LzoAlgorithm.LZO1B),
        LZO1B_7(LzoAlgorithm.LZO1B),
        LZO1B_8(LzoAlgorithm.LZO1B),
        LZO1B_9(LzoAlgorithm.LZO1B),
        LZO1B_99(LzoAlgorithm.LZO1B, LzoConstraint.COMPRESSION),
        LZO1B_999(LzoAlgorithm.LZO1B, LzoConstraint.COMPRESSION),
        LZO1C(LzoAlgorithm.LZO1C),
        LZO1C_BEST_COMPRESSION(LzoAlgorithm.LZO1C, LzoConstraint.COMPRESSION),
        LZO1C_BEST_SPEED(LzoAlgorithm.LZO1C, LzoConstraint.SPEED),
        LZO1C_1(LzoAlgorithm.LZO1C),
        LZO1C_2(LzoAlgorithm.LZO1C),
        LZO1C_3(LzoAlgorithm.LZO1C),
        LZO1C_4(LzoAlgorithm.LZO1C),
        LZO1C_5(LzoAlgorithm.LZO1C),
        LZO1C_6(LzoAlgorithm.LZO1C),
        LZO1C_7(LzoAlgorithm.LZO1C),
        LZO1C_8(LzoAlgorithm.LZO1C),
        LZO1C_9(LzoAlgorithm.LZO1C),
        LZO1C_99(LzoAlgorithm.LZO1C, LzoConstraint.COMPRESSION),
        LZO1C_999(LzoAlgorithm.LZO1C, LzoConstraint.COMPRESSION),
        LZO1F_1(LzoAlgorithm.LZO1F),
        LZO1F_999(LzoAlgorithm.LZO1F, LzoConstraint.COMPRESSION),
        LZO1X_1(LzoAlgorithm.LZO1X),
        LZO1X_11(LzoAlgorithm.LZO1X, LzoConstraint.MEMORY),
        LZO1X_12(LzoAlgorithm.LZO1X),
        LZO1X_15(LzoAlgorithm.LZO1X),
        LZO1X_999(LzoAlgorithm.LZO1X, LzoConstraint.COMPRESSION),
        LZO1Y_1(LzoAlgorithm.LZO1Y),
        LZO1Y_999(LzoAlgorithm.LZO1Y, LzoConstraint.COMPRESSION),
        LZO1Z_999(LzoAlgorithm.LZO1Z, LzoConstraint.COMPRESSION),
        LZO2A_999(LzoAlgorithm.LZO2A, LzoConstraint.COMPRESSION);

        private final LzoAlgorithm algorithm;
        private final LzoConstraint constraint;

        private CompressionStrategy(LzoAlgorithm algorithm, LzoConstraint constraint) {
            this.algorithm = algorithm;
            this.constraint = constraint;
        }

        private CompressionStrategy(LzoAlgorithm algorithm) {
            this(algorithm, null);
        }

        public org.anarres.lzo.LzoCompressor newCompressor() {
            return LzoLibrary.getInstance().newCompressor(this.algorithm, this.constraint);
        }
    }
}

