/*
 * Decompiled with CFR 0.152.
 */
package org.antora.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import java.util.concurrent.CompletionException;
import java.util.stream.Stream;

public class FileUtils {
    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.isDirectory()) {
            Files.deleteIfExists(directory.toPath());
            directory.mkdirs();
            return;
        }
        try (Stream<Path> walk = Files.walk(directory.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder());){
            walk.map(Path::toFile).filter(file -> !file.equals(directory)).forEach(File::delete);
        }
    }

    public static void copyRecursively(File src, File dest) throws IOException {
        int relativePathOffset = src.getPath().length();
        try (Stream<Path> walk = Files.walk(src.toPath(), new FileVisitOption[0]);){
            try {
                walk.forEach(file -> {
                    String relativePath = file.toString().substring(relativePathOffset);
                    try {
                        Files.copy(file, Path.of(dest.getPath(), relativePath), StandardCopyOption.COPY_ATTRIBUTES);
                    }
                    catch (IOException e) {
                        throw new CompletionException(e);
                    }
                });
            }
            catch (CompletionException e) {
                throw (IOException)e.getCause();
            }
        }
    }

    public static File currentDirectory() {
        return Path.of("", new String[0]).toAbsolutePath().toFile();
    }

    public static boolean deleteDirectory(File directory) throws IOException {
        if (!directory.isDirectory()) {
            return Files.deleteIfExists(directory.toPath());
        }
        try (Stream<Path> walk = Files.walk(directory.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder());){
            walk.map(Path::toFile).forEach(File::delete);
        }
        return true;
    }

    public static boolean hasContents(File file, String contents) {
        if (!file.exists()) {
            return false;
        }
        try {
            return contents.equals(Files.readString(file.toPath()).stripTrailing());
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isEmptyDirectory(File directory) {
        boolean bl;
        block9: {
            if (!directory.isDirectory()) {
                return false;
            }
            Stream<Path> entries = Files.list(directory.toPath());
            try {
                bl = entries.findFirst().isEmpty();
                if (entries == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (entries != null) {
                        try {
                            entries.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            entries.close();
        }
        return bl;
    }
}

