/*
 * Decompiled with CFR 0.152.
 */
package org.antora.maven;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Map;

public class PackageJsonExplorer {
    private static final String PACKAGE_JSON_NAME = "package.json";
    private static final String PACKAGE_LOCKFILE_NAME = "package-lock.json";
    private final File directory;
    private final File packageFile;
    private final File packageLockfile;

    public PackageJsonExplorer(File directory) {
        this.directory = directory;
        this.packageFile = new File(directory, PACKAGE_JSON_NAME);
        this.packageLockfile = new File(directory, PACKAGE_LOCKFILE_NAME);
    }

    public boolean hasPackageFileWithDependencies() {
        boolean bl;
        if (!this.packageFile.exists()) {
            return false;
        }
        FileReader reader = new FileReader(this.packageFile);
        try {
            JsonObject pkg = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            bl = pkg.has("dependencies") && !pkg.getAsJsonObject("dependencies").isEmpty() || pkg.has("devDependencies") && !pkg.getAsJsonObject("devDependencies").isEmpty();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
        reader.close();
        return bl;
    }

    public boolean hasLockfile() {
        return this.packageLockfile.exists();
    }

    public boolean isBinScriptInstalled(String name) {
        return this.directory.toPath().resolve(Path.of("node_modules", ".bin", name)).toFile().exists();
    }

    public String getPackageVersion(String packageName, boolean fromLockFile) {
        String string;
        FileReader reader = new FileReader(fromLockFile ? this.packageLockfile : this.packageFile);
        try {
            JsonObject pkg = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String version = null;
            if (fromLockFile) {
                version = this.getPackageVersion(pkg, "packages", packageName);
            } else {
                version = this.getPackageVersion(pkg, "dependencies", packageName);
                if (version == null) {
                    version = this.getPackageVersion(pkg, "devDependencies", packageName);
                }
            }
            string = version == null || version.contains(":") ? null : version;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        reader.close();
        return string;
    }

    private String getPackageVersion(JsonObject pkg, String property, String packageName) {
        JsonObject category = pkg.getAsJsonObject(property);
        if (category == null) {
            return null;
        }
        boolean fromLockFile = "packages".equals(property);
        if (fromLockFile) {
            packageName = "node_modules/" + (String)packageName;
        }
        for (Map.Entry entry : category.entrySet()) {
            if (!((String)packageName).equals(entry.getKey())) continue;
            JsonElement value = (JsonElement)entry.getValue();
            if (fromLockFile) {
                value = value.getAsJsonObject().get("version");
            }
            return value.getAsString();
        }
        return null;
    }
}

