/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.examples.appserver.custom;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.text.UrlEncoding;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.context.BaseResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.abdera.protocol.server.context.StreamWriterResponseContext;
import org.apache.abdera.protocol.server.impl.AbstractCollectionAdapter;
import org.apache.abdera.writer.StreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAdapter
extends AbstractCollectionAdapter {
    public String getAuthor(RequestContext request) throws ResponseContextException {
        return "Simple McGee";
    }

    public String getId(RequestContext request) {
        return "tag:example.org,2008:feed";
    }

    public String getHref(RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("collection", "feed");
        return request.urlFor((Object)TargetType.TYPE_COLLECTION, params);
    }

    public String getTitle(RequestContext request) {
        return "A simple feed";
    }

    public ResponseContext extensionRequest(RequestContext request) {
        return ProviderHelper.notallowed((RequestContext)request, (String)"Method Not Allowed", (String[])ProviderHelper.getDefaultMethods((RequestContext)request));
    }

    private Document<Feed> getFeedDocument(RequestContext context) throws ResponseContextException {
        Feed feed = (Feed)context.getAttribute(RequestContext.Scope.SESSION, "feed");
        if (feed == null) {
            feed = this.createFeedBase(context);
            feed.setBaseUri(this.getFeedBaseUri(context));
            context.setAttribute(RequestContext.Scope.SESSION, "feed", (Object)feed);
        }
        return feed.getDocument();
    }

    private String getFeedBaseUri(RequestContext context) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("collection", context.getTarget().getParameter("collection"));
        String uri = context.urlFor((Object)TargetType.TYPE_COLLECTION, params);
        return context.getResolvedUri().resolve(uri).toString();
    }

    public ResponseContext getFeed(RequestContext request) {
        Document<Feed> feed;
        try {
            feed = this.getFeedDocument(request);
        }
        catch (ResponseContextException e) {
            return e.getResponseContext();
        }
        return ProviderHelper.returnBase(feed, (int)200, (Date)((Feed)feed.getRoot()).getUpdated()).setEntityTag(ProviderHelper.calculateEntityTag((Base)feed.getRoot()));
    }

    public ResponseContext deleteEntry(RequestContext request) {
        Entry entry = this.getAbderaEntry(request);
        if (entry != null) {
            entry.discard();
        }
        return ProviderHelper.nocontent();
    }

    public ResponseContext getEntry(RequestContext request) {
        Entry entry = this.getAbderaEntry(request);
        if (entry != null) {
            Feed feed = (Feed)entry.getParentElement();
            entry = (Entry)entry.clone();
            entry.setSource(feed.getAsSource());
            Document entry_doc = entry.getDocument();
            return ProviderHelper.returnBase((Base)entry_doc, (int)200, (Date)entry.getEdited()).setEntityTag(ProviderHelper.calculateEntityTag((Base)entry));
        }
        return ProviderHelper.notfound((RequestContext)request);
    }

    public ResponseContext postEntry(RequestContext request) {
        Abdera abdera = request.getAbdera();
        try {
            Document entry_doc = (Document)request.getDocument(abdera.getParser()).clone();
            if (entry_doc != null) {
                Entry entry = (Entry)entry_doc.getRoot();
                if (!ProviderHelper.isValidEntry((Entry)entry)) {
                    return ProviderHelper.badrequest((RequestContext)request);
                }
                this.setEntryDetails(request, entry, abdera.getFactory().newUuidUri());
                Feed feed = (Feed)this.getFeedDocument(request).getRoot();
                feed.insertEntry(entry);
                feed.setUpdated(new Date());
                BaseResponseContext rc = (BaseResponseContext)ProviderHelper.returnBase((Base)entry_doc, (int)201, (Date)entry.getEdited());
                return rc.setLocation(ProviderHelper.resolveBase((RequestContext)request).resolve(entry.getEditLinkResolvedHref()).toString()).setContentLocation(rc.getLocation().toString()).setEntityTag(ProviderHelper.calculateEntityTag((Base)entry));
            }
            return ProviderHelper.badrequest((RequestContext)request);
        }
        catch (ParseException pe) {
            return ProviderHelper.notsupported((RequestContext)request);
        }
        catch (ClassCastException cce) {
            return ProviderHelper.notsupported((RequestContext)request);
        }
        catch (Exception e) {
            return ProviderHelper.badrequest((RequestContext)request);
        }
    }

    private void setEntryDetails(RequestContext request, Entry entry, String id) {
        entry.setUpdated(new Date());
        entry.setEdited(entry.getUpdated());
        entry.getIdElement().setValue(id);
        entry.addLink(this.getEntryLink(request, entry.getId().toASCIIString()), "edit");
    }

    private String getEntryLink(RequestContext request, String entryid) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("collection", request.getTarget().getParameter("collection"));
        params.put("entry", entryid);
        return request.urlFor((Object)TargetType.TYPE_ENTRY, params);
    }

    public ResponseContext putEntry(RequestContext request) {
        Abdera abdera = request.getAbdera();
        Entry orig_entry = this.getAbderaEntry(request);
        if (orig_entry != null) {
            try {
                Document entry_doc = (Document)request.getDocument(abdera.getParser()).clone();
                if (entry_doc != null) {
                    Entry entry = (Entry)entry_doc.getRoot();
                    if (!entry.getId().equals((Object)orig_entry.getId())) {
                        return ProviderHelper.conflict((RequestContext)request);
                    }
                    if (!ProviderHelper.isValidEntry((Entry)entry)) {
                        return ProviderHelper.badrequest((RequestContext)request);
                    }
                    this.setEntryDetails(request, entry, orig_entry.getId().toString());
                    orig_entry.discard();
                    Feed feed = (Feed)this.getFeedDocument(request).getRoot();
                    feed.insertEntry(entry);
                    feed.setUpdated(new Date());
                    return ProviderHelper.nocontent();
                }
                return ProviderHelper.badrequest((RequestContext)request);
            }
            catch (ParseException pe) {
                return ProviderHelper.notsupported((RequestContext)request);
            }
            catch (ClassCastException cce) {
                return ProviderHelper.notsupported((RequestContext)request);
            }
            catch (Exception e) {
                return ProviderHelper.badrequest((RequestContext)request);
            }
        }
        return ProviderHelper.notfound((RequestContext)request);
    }

    private Entry getAbderaEntry(RequestContext request) {
        try {
            return ((Feed)this.getFeedDocument(request).getRoot()).getEntry(this.getEntryID(request));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getEntryID(RequestContext request) {
        if (request.getTarget().getType() != TargetType.TYPE_ENTRY) {
            return null;
        }
        String[] segments = request.getUri().toString().split("/");
        return UrlEncoding.decode((String)segments[segments.length - 1]);
    }

    public ResponseContext getCategories(RequestContext request) {
        return new StreamWriterResponseContext(request.getAbdera()){

            protected void writeTo(StreamWriter sw) throws IOException {
                sw.startDocument().startCategories(false).writeCategory("foo").writeCategory("bar").writeCategory("baz").endCategories().endDocument();
            }
        }.setStatus(200).setContentType("application/atomcat+xml");
    }
}

