/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.examples.xsltxpath;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Source;
import org.apache.abdera.parser.stax.FOMXPath;
import org.apache.abdera.xpath.XPath;
import org.apache.axiom.om.OMNode;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;

public class XPathFunctionsExample {
    public static void main(String ... args) throws Exception {
        Abdera abdera = Abdera.getInstance();
        Feed feed = abdera.newFeed();
        feed.setBaseUri("http://example.org/");
        Entry entry = feed.addEntry();
        entry.addLink("alternate.xml");
        XPath xpath = abdera.getXPath();
        System.out.println(xpath.valueOf("abdera:resolve(/a:feed/a:entry/a:link/@href)", (Base)feed));
        FOMXPath fxpath = (FOMXPath)xpath;
        Map functions = fxpath.getDefaultFunctions();
        functions.put(AlternateLinkFunction.QNAME, new AlternateLinkFunction());
        fxpath.setDefaultFunctions(functions);
        List links = fxpath.selectNodes("abdera:altlinks(/a:feed/a:entry)", (Base)feed);
        System.out.println(links);
    }

    public static class AlternateLinkFunction
    implements Function {
        public static final QName QNAME = new QName("http://abdera.apache.org", "altlinks");

        public Object call(Context context, List args) throws FunctionCallException {
            ArrayList results = new ArrayList();
            if (args.isEmpty()) {
                return null;
            }
            for (Object obj : args) {
                if (!(obj instanceof List)) continue;
                for (Object o : (List)obj) {
                    try {
                        if (!(o instanceof OMNode)) continue;
                        OMNode node = (OMNode)o;
                        List links = null;
                        if (node instanceof Source) {
                            Source source = (Source)node;
                            links = source.getLinks("alternate");
                        } else if (node instanceof Entry) {
                            Entry entry = (Entry)node;
                            links = entry.getLinks("alternate");
                        }
                        if (links == null) continue;
                        results.addAll(links);
                    }
                    catch (Exception e) {}
                }
            }
            return results;
        }
    }
}

