/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.StompFrame;

public interface FrameTranslator {
    public ActiveMQMessage convertFrame(ProtocolConverter var1, StompFrame var2) throws JMSException, ProtocolException;

    public StompFrame convertMessage(ProtocolConverter var1, ActiveMQMessage var2) throws IOException, JMSException;

    public String convertDestination(ProtocolConverter var1, Destination var2);

    public ActiveMQDestination convertDestination(ProtocolConverter var1, String var2, boolean var3) throws ProtocolException;

    public static final class Helper {
        private Helper() {
        }

        public static void copyStandardHeadersFromMessageToFrame(ProtocolConverter converter, ActiveMQMessage message, StompFrame command, FrameTranslator ft) throws IOException {
            Map<String, Object> properties;
            Map<String, String> headers = command.getHeaders();
            headers.put("destination", ft.convertDestination(converter, message.getDestination()));
            headers.put("message-id", message.getJMSMessageID());
            if (message.getJMSCorrelationID() != null) {
                headers.put("correlation-id", message.getJMSCorrelationID());
            }
            headers.put("expires", "" + message.getJMSExpiration());
            if (message.getJMSRedelivered()) {
                headers.put("redelivered", "true");
            }
            headers.put("priority", "" + message.getJMSPriority());
            if (message.getJMSReplyTo() != null) {
                headers.put("reply-to", ft.convertDestination(converter, message.getJMSReplyTo()));
            }
            headers.put("timestamp", "" + message.getJMSTimestamp());
            if (message.getJMSType() != null) {
                headers.put("type", message.getJMSType());
            }
            if (message.getUserID() != null) {
                headers.put("JMSXUserID", message.getUserID());
            }
            if (message.getOriginalDestination() != null) {
                headers.put("original-destination", ft.convertDestination(converter, message.getOriginalDestination()));
            }
            if (message.isPersistent()) {
                headers.put("persistent", "true");
            }
            if ((properties = message.getProperties()) != null) {
                for (Map.Entry<String, Object> prop : properties.entrySet()) {
                    headers.put(prop.getKey(), "" + prop.getValue());
                }
            }
        }

        public static void copyStandardHeadersFromFrameToMessage(ProtocolConverter converter, StompFrame command, ActiveMQMessage msg, FrameTranslator ft) throws ProtocolException, JMSException {
            HashMap<String, String> headers = new HashMap<String, String>(command.getHeaders());
            String destination = (String)headers.remove("destination");
            msg.setDestination(ft.convertDestination(converter, destination, true));
            msg.setJMSCorrelationID((String)headers.remove("correlation-id"));
            Object o = headers.remove("expires");
            if (o != null) {
                msg.setJMSExpiration(Long.parseLong((String)o));
            }
            if ((o = headers.remove("timestamp")) != null) {
                msg.setJMSTimestamp(Long.parseLong((String)o));
            } else {
                msg.setJMSTimestamp(System.currentTimeMillis());
            }
            o = headers.remove("priority");
            if (o != null) {
                msg.setJMSPriority(Integer.parseInt((String)o));
            } else {
                msg.setJMSPriority(4);
            }
            o = headers.remove("type");
            if (o != null) {
                msg.setJMSType((String)o);
            }
            if ((o = headers.remove("reply-to")) != null) {
                try {
                    ActiveMQDestination dest = ft.convertDestination(converter, (String)o, false);
                    msg.setJMSReplyTo(dest);
                }
                catch (ProtocolException pe) {
                    msg.setStringProperty("reply-to", (String)o);
                }
            }
            if ((o = headers.remove("persistent")) != null) {
                msg.setPersistent("true".equals(o));
            }
            headers.remove("receipt");
            headers.remove("message-id");
            headers.remove("redelivered");
            headers.remove("subscription");
            headers.remove("JMSXUserID");
            msg.setProperties(headers);
        }
    }
}

