/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.factory;

import java.io.IOException;
import java.net.URI;
import org.apache.activemq.artemis.cli.ConfigurationException;
import org.apache.activemq.artemis.cli.factory.BrokerFactoryHandler;
import org.apache.activemq.artemis.cli.factory.BrokerHandler;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.dto.BrokerDTO;
import org.apache.activemq.artemis.dto.ServerDTO;
import org.apache.activemq.artemis.integration.Broker;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.utils.FactoryFinder;

public class BrokerFactory {
    private static BrokerDTO createBrokerConfiguration(URI configURI, String artemisHome, String artemisInstance, URI artemisURIInstance) throws Exception {
        if (configURI.getScheme() == null) {
            throw new ConfigurationException("Invalid configuration URI, no scheme specified: " + configURI);
        }
        BrokerFactoryHandler factory = null;
        try {
            FactoryFinder finder = new FactoryFinder("META-INF/services/org/apache/activemq/artemis/broker/");
            factory = (BrokerFactoryHandler)finder.newInstance(configURI.getScheme());
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Invalid configuration URI, can't find configuration scheme: " + configURI.getScheme());
        }
        return factory.createBroker(configURI, artemisHome, artemisInstance, artemisURIInstance);
    }

    public static BrokerDTO createBrokerConfiguration(String configuration, String artemisHome, String artemisInstance, URI artemisURIInstance) throws Exception {
        return BrokerFactory.createBrokerConfiguration(new URI(configuration), artemisHome, artemisInstance, artemisURIInstance);
    }

    public static Broker createServer(ServerDTO brokerDTO, ActiveMQSecurityManager security, ActivateCallback activateCallback) throws Exception {
        if (brokerDTO.configuration != null) {
            BrokerHandler handler;
            URI configURI = brokerDTO.getConfigurationURI();
            try {
                FactoryFinder finder = new FactoryFinder("META-INF/services/org/apache/activemq/artemis/broker/server/");
                handler = (BrokerHandler)finder.newInstance(configURI.getScheme());
            }
            catch (IOException ioe) {
                throw new ConfigurationException("Invalid configuration URI, can't find configuration scheme: " + configURI.getScheme());
            }
            return handler.createServer(brokerDTO, security, activateCallback);
        }
        return null;
    }
}

