/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactory;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalImpl;
import org.apache.activemq.artemis.utils.ExecutorFactory;

public class JDBCJournalStorageManager
extends JournalStorageManager {
    public JDBCJournalStorageManager(Configuration config, ExecutorFactory executorFactory) {
        super(config, executorFactory);
    }

    public JDBCJournalStorageManager(Configuration config, ExecutorFactory executorFactory, IOCriticalErrorListener criticalErrorListener) {
        super(config, executorFactory, criticalErrorListener);
    }

    @Override
    protected synchronized void init(Configuration config, IOCriticalErrorListener criticalErrorListener) {
        try {
            DatabaseStorageConfiguration dbConf = (DatabaseStorageConfiguration)config.getStoreConfiguration();
            JDBCJournalImpl localBindings = new JDBCJournalImpl(dbConf.getJdbcConnectionUrl(), dbConf.getBindingsTableName(), dbConf.getJdbcDriverClassName());
            this.bindingsJournal = localBindings;
            JDBCJournalImpl localMessage = new JDBCJournalImpl(dbConf.getJdbcConnectionUrl(), dbConf.getMessageTableName(), dbConf.getJdbcDriverClassName());
            this.messageJournal = localMessage;
            this.bindingsJournal.start();
            this.messageJournal.start();
            this.largeMessagesFactory = new JDBCSequentialFileFactory(dbConf.getJdbcConnectionUrl(), dbConf.getLargeMessageTableName(), dbConf.getJdbcDriverClassName(), this.executor);
            this.largeMessagesFactory.start();
        }
        catch (Exception e) {
            criticalErrorListener.onIOException((Throwable)e, e.getMessage(), null);
        }
    }

    @Override
    public synchronized void stop(boolean ioCriticalError) throws Exception {
        if (!this.started) {
            return;
        }
        if (!ioCriticalError) {
            this.performCachedLargeMessageDeletes();
            if (this.journalLoaded && this.idGenerator != null) {
                this.idGenerator.persistCurrentID();
            }
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await(30L, TimeUnit.SECONDS);
        this.beforeStop();
        this.bindingsJournal.stop();
        this.messageJournal.stop();
        this.largeMessagesFactory.stop();
        this.singleThreadExecutor.shutdown();
        this.journalLoaded = false;
        this.started = false;
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        return NIOSequentialFileFactory.allocateDirectByteBuffer((int)size);
    }

    @Override
    public void freeDirectBuffer(ByteBuffer buffer) {
    }
}

