/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQClusterSecurityException;
import org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQDuplicateMetaDataException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQIncompatibleClientServerException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidTransientQueueUseException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;

public class ActiveMQMessageBundle_$bundle
implements ActiveMQMessageBundle,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ActiveMQMessageBundle_$bundle INSTANCE = new ActiveMQMessageBundle_$bundle();
    private static final String activationForServer = "AMQ119000: Activation for server {0}";
    private static final String generatingThreadDump = "AMQ119001: Generating thread dump";
    private static final String threadDump = "AMQ119002: Thread {0} name = {1} id = {2} group = {3}";
    private static final String endThreadDump = "AMQ119003: End Thread dump";
    private static final String serverDescribe = "AMQ119004: Information about server {0}\nCluster Connection:{1}";
    private static final String connectionsClosedByManagement = "AMQ119005: connections for {0} closed by management";
    private static final String notJournalImpl = "AMQ119006: journals are not JournalImpl. You can''t set a replicator!";
    private static final String replicationUnhandledError = "AMQ119007: unhandled error during replication";
    private static final String replicationTooManyJournals = "AMQ119008: Live Node contains more journals than the backup node. Probably a version match error";
    private static final String replicationUnhandledFileType = "AMQ119009: Unhandled file type {0}";
    private static final String replicationBackupUpToDate = "AMQ119010: Remote Backup can not be up-to-date!";
    private static final String replicationUnhandledDataType = "AMQ119011: unhandled data type!";
    private static final String noBindingForDivert = "AMQ119012: No binding for divert {0}";
    private static final String bindingNotDivert = "AMQ119013: Binding {0} is not a divert";
    private static final String clientExited = "AMQ119014: Did not receive data from {0} within the {1}ms connection TTL. The connection will now be closed.";
    private static final String noSuchQueue = "AMQ119017: Queue {0} does not exist";
    private static final String bindingAlreadyExists = "AMQ119018: Binding already exists {0}";
    private static final String queueAlreadyExists = "AMQ119019: Queue already exists {0}";
    private static final String invalidFilter = "AMQ119020: Invalid filter: {0}";
    private static final String messageIdNotAssigned = "AMQ119021: MessageId was not assigned to Message";
    private static final String journalsNotInSync = "AMQ119022: Cannot compare journals if not in sync!";
    private static final String serverNotBackupServer = "AMQ119023: Connected server is not a backup server";
    private static final String alreadyHaveReplicationServer = "AMQ119024: Backup replication server is already connected to another server";
    private static final String cannotDeleteQueue = "AMQ119025: Cannot delete queue {0} on binding {1} - it has consumers = {2}";
    private static final String backupServerNotInSync = "AMQ119026: Backup Server was not yet in sync with live";
    private static final String consumerNoReference = "AMQ119027: Could not find reference on consumer ID={0}, messageId = {1} queue = {2}";
    private static final String consumerDoesntExist = "AMQ119028: Consumer {0} doesn''t exist on the server";
    private static final String noAddress = "AMQ119029: No address configured on the Server''s Session";
    private static final String largeMessageNotInitialised = "AMQ119030: large-message not initialized on server";
    private static final String unableToValidateUser = "AMQ119031: Unable to validate user";
    private static final String userNoPermissions = "AMQ119032: User: {0} does not have permission=''{1}'' on address {2}";
    private static final String incompatibleClientServer = "AMQ119033: Server and client versions incompatible";
    private static final String serverNotStarted = "AMQ119034: Server not started";
    private static final String duplicateMetadata = "AMQ119035: Metadata {0}={1} had been set already";
    private static final String invalidType = "AMQ119036: Invalid type: {0}";
    private static final String emptyOrNull = "AMQ119038: {0} must neither be null nor empty";
    private static final String greaterThanZero2 = "AMQ119039: {0}  must be greater than 0 (actual value: {1})";
    private static final String notPercent = "AMQ119040: {0} must be a valid percentual value between 0 and 100 (actual value: {1})";
    private static final String greaterThanMinusOne = "AMQ119041: {0}  must be equals to -1 or greater than 0 (actual value: {1})";
    private static final String greaterThanZeroOrMinusOne = "AMQ119042: {0}  must be equals to -1 or greater or equals to 0 (actual value: {1})";
    private static final String mustbeBetween = "AMQ119043: {0} must be between {1} and {2} inclusive (actual value: {3})";
    private static final String invalidJournalType = "AMQ119044: Invalid journal type {0}";
    private static final String invalidAddressFullPolicyType = "AMQ119045: Invalid address full message policy type {0}";
    private static final String greaterThanZero1 = "AMQ119046: invalid value: {0} count must be greater than 0";
    private static final String invalidMessageCounterPeriod = "AMQ119047: Cannot set Message Counter Sample Period < {0}ms";
    private static final String invalidNewPriority = "AMQ119048: invalid new Priority value: {0}. It must be between 0 and 9 (both included)";
    private static final String noQueueFound = "AMQ119049: No queue found for {0}";
    private static final String invalidJournal = "AMQ119050: Only NIO and AsyncIO are supported journals";
    private static final String invalidJournalType2 = "AMQ119051: Invalid journal type {0}";
    private static final String cannotCreateDir = "AMQ119052: Directory {0} does not exist and cannot be created";
    private static final String cannotConvertToInt = "AMQ119054: Cannot convert to int";
    private static final String routeNameIsNull = "AMQ119055: Routing name is null";
    private static final String clusterNameIsNull = "AMQ119056: Cluster name is null";
    private static final String addressIsNull = "AMQ119057: Address is null";
    private static final String bindingTypeNotSpecified = "AMQ119058: Binding type not specified";
    private static final String bindingIdNotSpecified = "AMQ119059: Binding ID is null";
    private static final String distancenotSpecified = "AMQ119060: Distance is null";
    private static final String connectionExists = "AMQ119061: Connection already exists with id {0}";
    private static final String acceptorExists = "AMQ119062: Acceptor with id {0} already registered";
    private static final String acceptorNotExists = "AMQ119063: Acceptor with id {0} not registered";
    private static final String unknownProtocol = "AMQ119064: Unknown protocol {0}";
    private static final String nodeIdNull = "AMQ119065: node id is null";
    private static final String queueNameIsNull = "AMQ119066: Queue name is null";
    private static final String cannotFindResource = "AMQ119067: Cannot find resource with name {0}";
    private static final String noGetterMethod = "AMQ119068: no getter method for {0}";
    private static final String noOperation = "AMQ119069: no operation {0}/{1}";
    private static final String nullMatch = "AMQ119070: match can not be null";
    private static final String invalidMatch = "AMQ119071: # can only be at end of match";
    private static final String nullUser = "AMQ119072: User cannot be null";
    private static final String nullPassword = "AMQ119073: Password cannot be null";
    private static final String errorCreatingTransformerClass = "AMQ119074: Error instantiating transformer class {0}";
    private static final String autoConvertError = "AMQ119075: method autoEncode doesn''t know how to convert {0} yet";
    private static final String destroyConnectionWithSessionMetadataHeader = "AMQ119076: Executing destroyConnection with {0}={1} through management''s request";
    private static final String destroyConnectionWithSessionMetadataClosingConnection = "AMQ119077: Closing connection {0}";
    private static final String destroyConnectionWithSessionMetadataSendException = "AMQ119078: Disconnected per admin''s request on {0}={1}";
    private static final String destroyConnectionWithSessionMetadataNoSessionFound = "AMQ119079: No session found with {0}={1}";
    private static final String invalidPageIO = "AMQ119080: Invalid Page IO, PagingManager was stopped or closed";
    private static final String noDiscoveryGroupFound = "AMQ119081: No Discovery Group configuration named {0} found";
    private static final String queueSubscriptionBelongsToDifferentAddress = "AMQ119082: Queue {0} already exists on another subscription";
    private static final String queueSubscriptionBelongsToDifferentFilter = "AMQ119083: Queue {0} has a different filter than requested";
    private static final String unableToValidateClusterUser = "AMQ119099: Unable to authenticate cluster user: {0}";
    private static final String journalDirIsFile = "AMQ119100: Trying to move a journal file that refers to a file instead of a directory: {0}";
    private static final String couldNotMoveJournal = "AMQ119101: error trying to backup journal files at directory: {0}";
    private static final String addressIsFull = "AMQ119102: Address \"{0}\" is full.";
    private static final String noConfigurationFoundForScaleDown = "AMQ119103: No Connectors or Discovery Groups configured for Scale Down";
    private static final String groupWhileStopping = "AMQ119104: Server is stopping. Message grouping not allowed";
    private static final String invalidSlowConsumerPolicyType = "AMQ119106: Invalid slow consumer policy type {0}";
    private static final String consumerConnectionsClosedByManagement = "AMQ119107: consumer connections for address {0} closed by management";
    private static final String connectionsForUserClosedByManagement = "AMQ119108: connections for user {0} closed by management";
    private static final String unsupportedHAPolicyConfiguration = "AMQ119109: unsupported HA Policy Configuration {0}";
    private static final String sessionLimitReached = "AMQ119110: Too many sessions for user ''{0}''. Sessions allowed: {1}.";
    private static final String queueLimitReached = "AMQ119111: Too many queues created by user ''{0}''. Queues allowed: {1}.";
    private static final String cannotSetMBeanserver = "AMQ119112: Cannot set MBeanServer during startup or while started";
    private static final String invalidMessageLoadBalancingType = "AMQ119113: Invalid message load balancing type {0}";
    private static final String replicationSynchronizationTimeout = "AMQ119114: Replication synchronization process timed out after waiting {0} milliseconds";
    private static final String liveBackupMismatch = "AMQ119115: Colocated Policy hasn't different type live and backup";
    private static final String acceptorUnavailable = "AMQ119116: Netty Acceptor unavailable";
    private static final String replicatorIsNull = "AMQ119117: Replicator is null. Replication was likely terminated.";
    private static final String methodNotApplicable = "AMQ119118: Management method not applicable for current server configuration";
    private static final String diskBeyondLimit = "AMQ119119: Disk Capacity is Low, cannot produce more messages.";

    protected ActiveMQMessageBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected String activationForServer$str() {
        return activationForServer;
    }

    @Override
    public final String activationForServer(ActiveMQServer server) {
        return MessageFormat.format(this.activationForServer$str(), server);
    }

    protected String generatingThreadDump$str() {
        return generatingThreadDump;
    }

    @Override
    public final String generatingThreadDump() {
        return this.generatingThreadDump$str();
    }

    protected String threadDump$str() {
        return threadDump;
    }

    @Override
    public final String threadDump(Thread key, String name, Long id, ThreadGroup threadGroup) {
        return MessageFormat.format(this.threadDump$str(), key, name, id, threadGroup);
    }

    protected String endThreadDump$str() {
        return endThreadDump;
    }

    @Override
    public final String endThreadDump() {
        return String.format(this.endThreadDump$str(), new Object[0]);
    }

    protected String serverDescribe$str() {
        return serverDescribe;
    }

    @Override
    public final String serverDescribe(String identity, String describe) {
        return MessageFormat.format(this.serverDescribe$str(), identity, describe);
    }

    protected String connectionsClosedByManagement$str() {
        return connectionsClosedByManagement;
    }

    @Override
    public final ActiveMQInternalErrorException connectionsClosedByManagement(String ipAddress) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(MessageFormat.format(this.connectionsClosedByManagement$str(), ipAddress));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notJournalImpl$str() {
        return notJournalImpl;
    }

    @Override
    public final ActiveMQInternalErrorException notJournalImpl() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.notJournalImpl$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationUnhandledError$str() {
        return replicationUnhandledError;
    }

    @Override
    public final ActiveMQInternalErrorException replicationUnhandledError(Exception e) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.replicationUnhandledError$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationTooManyJournals$str() {
        return replicationTooManyJournals;
    }

    @Override
    public final ActiveMQInternalErrorException replicationTooManyJournals() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.replicationTooManyJournals$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationUnhandledFileType$str() {
        return replicationUnhandledFileType;
    }

    @Override
    public final ActiveMQInternalErrorException replicationUnhandledFileType(ReplicationSyncFileMessage.FileType fileType) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(MessageFormat.format(this.replicationUnhandledFileType$str(), new Object[]{fileType}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationBackupUpToDate$str() {
        return replicationBackupUpToDate;
    }

    @Override
    public final ActiveMQInternalErrorException replicationBackupUpToDate() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.replicationBackupUpToDate$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationUnhandledDataType$str() {
        return replicationUnhandledDataType;
    }

    @Override
    public final ActiveMQInternalErrorException replicationUnhandledDataType() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.replicationUnhandledDataType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noBindingForDivert$str() {
        return noBindingForDivert;
    }

    @Override
    public final ActiveMQInternalErrorException noBindingForDivert(SimpleString name) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(MessageFormat.format(this.noBindingForDivert$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingNotDivert$str() {
        return bindingNotDivert;
    }

    @Override
    public final ActiveMQInternalErrorException bindingNotDivert(SimpleString name) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(MessageFormat.format(this.bindingNotDivert$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clientExited$str() {
        return clientExited;
    }

    @Override
    public final ActiveMQConnectionTimedOutException clientExited(String remoteAddress, long ttl) {
        ActiveMQConnectionTimedOutException result = new ActiveMQConnectionTimedOutException(MessageFormat.format(this.clientExited$str(), remoteAddress, ttl));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSuchQueue$str() {
        return noSuchQueue;
    }

    @Override
    public final ActiveMQNonExistentQueueException noSuchQueue(SimpleString queueName) {
        ActiveMQNonExistentQueueException result = new ActiveMQNonExistentQueueException(MessageFormat.format(this.noSuchQueue$str(), queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingAlreadyExists$str() {
        return bindingAlreadyExists;
    }

    @Override
    public final ActiveMQQueueExistsException bindingAlreadyExists(Binding binding) {
        ActiveMQQueueExistsException result = new ActiveMQQueueExistsException(MessageFormat.format(this.bindingAlreadyExists$str(), binding));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueAlreadyExists$str() {
        return queueAlreadyExists;
    }

    @Override
    public final ActiveMQQueueExistsException queueAlreadyExists(SimpleString queueName) {
        ActiveMQQueueExistsException result = new ActiveMQQueueExistsException(MessageFormat.format(this.queueAlreadyExists$str(), queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFilter$str() {
        return invalidFilter;
    }

    @Override
    public final ActiveMQInvalidFilterExpressionException invalidFilter(Throwable e, SimpleString filter) {
        ActiveMQInvalidFilterExpressionException result = new ActiveMQInvalidFilterExpressionException(MessageFormat.format(this.invalidFilter$str(), filter));
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String messageIdNotAssigned$str() {
        return messageIdNotAssigned;
    }

    @Override
    public final ActiveMQIllegalStateException messageIdNotAssigned() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.messageIdNotAssigned$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String journalsNotInSync$str() {
        return journalsNotInSync;
    }

    @Override
    public final ActiveMQIllegalStateException journalsNotInSync() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.journalsNotInSync$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serverNotBackupServer$str() {
        return serverNotBackupServer;
    }

    @Override
    public final ActiveMQIllegalStateException serverNotBackupServer() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.serverNotBackupServer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String alreadyHaveReplicationServer$str() {
        return alreadyHaveReplicationServer;
    }

    @Override
    public final ActiveMQIllegalStateException alreadyHaveReplicationServer() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.alreadyHaveReplicationServer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeleteQueue$str() {
        return cannotDeleteQueue;
    }

    @Override
    public final ActiveMQIllegalStateException cannotDeleteQueue(SimpleString name, SimpleString queueName, String s) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(MessageFormat.format(this.cannotDeleteQueue$str(), name, queueName, s));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String backupServerNotInSync$str() {
        return backupServerNotInSync;
    }

    @Override
    public final ActiveMQIllegalStateException backupServerNotInSync() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.backupServerNotInSync$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String consumerNoReference$str() {
        return consumerNoReference;
    }

    @Override
    public final ActiveMQIllegalStateException consumerNoReference(Long id, Long messageID, SimpleString name) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(MessageFormat.format(this.consumerNoReference$str(), id, messageID, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String consumerDoesntExist$str() {
        return consumerDoesntExist;
    }

    @Override
    public final ActiveMQIllegalStateException consumerDoesntExist(long consumerID) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(MessageFormat.format(this.consumerDoesntExist$str(), consumerID));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noAddress$str() {
        return noAddress;
    }

    @Override
    public final ActiveMQIllegalStateException noAddress() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.noAddress$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String largeMessageNotInitialised$str() {
        return largeMessageNotInitialised;
    }

    @Override
    public final ActiveMQIllegalStateException largeMessageNotInitialised() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.largeMessageNotInitialised$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToValidateUser$str() {
        return unableToValidateUser;
    }

    @Override
    public final ActiveMQSecurityException unableToValidateUser() {
        ActiveMQSecurityException result = new ActiveMQSecurityException(this.unableToValidateUser$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String userNoPermissions$str() {
        return userNoPermissions;
    }

    @Override
    public final ActiveMQSecurityException userNoPermissions(String username, CheckType checkType, String saddress) {
        ActiveMQSecurityException result = new ActiveMQSecurityException(MessageFormat.format(this.userNoPermissions$str(), new Object[]{username, checkType, saddress}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incompatibleClientServer$str() {
        return incompatibleClientServer;
    }

    @Override
    public final ActiveMQIncompatibleClientServerException incompatibleClientServer() {
        ActiveMQIncompatibleClientServerException result = new ActiveMQIncompatibleClientServerException(String.format(this.incompatibleClientServer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serverNotStarted$str() {
        return serverNotStarted;
    }

    @Override
    public final ActiveMQSessionCreationException serverNotStarted() {
        ActiveMQSessionCreationException result = new ActiveMQSessionCreationException(String.format(this.serverNotStarted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateMetadata$str() {
        return duplicateMetadata;
    }

    @Override
    public final ActiveMQDuplicateMetaDataException duplicateMetadata(String key, String data) {
        ActiveMQDuplicateMetaDataException result = new ActiveMQDuplicateMetaDataException(MessageFormat.format(this.duplicateMetadata$str(), key, data));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidType$str() {
        return invalidType;
    }

    @Override
    public final IllegalArgumentException invalidType(Object type) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String emptyOrNull$str() {
        return emptyOrNull;
    }

    @Override
    public final IllegalArgumentException emptyOrNull(String name) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.emptyOrNull$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanZero2$str() {
        return greaterThanZero2;
    }

    @Override
    public final IllegalArgumentException greaterThanZero(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.greaterThanZero2$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notPercent$str() {
        return notPercent;
    }

    @Override
    public final IllegalArgumentException notPercent(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.notPercent$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanMinusOne$str() {
        return greaterThanMinusOne;
    }

    @Override
    public final IllegalArgumentException greaterThanMinusOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.greaterThanMinusOne$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanZeroOrMinusOne$str() {
        return greaterThanZeroOrMinusOne;
    }

    @Override
    public final IllegalArgumentException greaterThanZeroOrMinusOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.greaterThanZeroOrMinusOne$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustbeBetween$str() {
        return mustbeBetween;
    }

    @Override
    public final IllegalArgumentException mustbeBetween(String name, Integer minPriority, Integer maxPriority, Object value) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.mustbeBetween$str(), name, minPriority, maxPriority, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJournalType$str() {
        return invalidJournalType;
    }

    @Override
    public final IllegalArgumentException invalidJournalType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidJournalType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAddressFullPolicyType$str() {
        return invalidAddressFullPolicyType;
    }

    @Override
    public final IllegalArgumentException invalidAddressFullPolicyType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidAddressFullPolicyType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanZero1$str() {
        return greaterThanZero1;
    }

    @Override
    public final IllegalArgumentException greaterThanZero(Integer count) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.greaterThanZero1$str(), count));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMessageCounterPeriod$str() {
        return invalidMessageCounterPeriod;
    }

    @Override
    public final IllegalArgumentException invalidMessageCounterPeriod(Long period) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidMessageCounterPeriod$str(), period));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNewPriority$str() {
        return invalidNewPriority;
    }

    @Override
    public final IllegalArgumentException invalidNewPriority(Integer period) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidNewPriority$str(), period));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noQueueFound$str() {
        return noQueueFound;
    }

    @Override
    public final IllegalArgumentException noQueueFound(String otherQueueName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.noQueueFound$str(), otherQueueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJournal$str() {
        return invalidJournal;
    }

    @Override
    public final IllegalArgumentException invalidJournal() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidJournal$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJournalType2$str() {
        return invalidJournalType2;
    }

    @Override
    public final IllegalArgumentException invalidJournalType2(JournalType journalType) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidJournalType2$str(), new Object[]{journalType}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateDir$str() {
        return cannotCreateDir;
    }

    @Override
    public final IllegalArgumentException cannotCreateDir(String dir) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.cannotCreateDir$str(), dir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConvertToInt$str() {
        return cannotConvertToInt;
    }

    @Override
    public final IllegalArgumentException cannotConvertToInt() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.cannotConvertToInt$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String routeNameIsNull$str() {
        return routeNameIsNull;
    }

    @Override
    public final IllegalArgumentException routeNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.routeNameIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clusterNameIsNull$str() {
        return clusterNameIsNull;
    }

    @Override
    public final IllegalArgumentException clusterNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.clusterNameIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String addressIsNull$str() {
        return addressIsNull;
    }

    @Override
    public final IllegalArgumentException addressIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.addressIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingTypeNotSpecified$str() {
        return bindingTypeNotSpecified;
    }

    @Override
    public final IllegalArgumentException bindingTypeNotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.bindingTypeNotSpecified$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingIdNotSpecified$str() {
        return bindingIdNotSpecified;
    }

    @Override
    public final IllegalArgumentException bindingIdNotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.bindingIdNotSpecified$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String distancenotSpecified$str() {
        return distancenotSpecified;
    }

    @Override
    public final IllegalArgumentException distancenotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.distancenotSpecified$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionExists$str() {
        return connectionExists;
    }

    @Override
    public final IllegalArgumentException connectionExists(Object id) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.connectionExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String acceptorExists$str() {
        return acceptorExists;
    }

    @Override
    public final IllegalArgumentException acceptorExists(Integer id) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.acceptorExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String acceptorNotExists$str() {
        return acceptorNotExists;
    }

    @Override
    public final IllegalArgumentException acceptorNotExists(Integer id) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.acceptorNotExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownProtocol$str() {
        return unknownProtocol;
    }

    @Override
    public final IllegalArgumentException unknownProtocol(String protocol) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.unknownProtocol$str(), protocol));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nodeIdNull$str() {
        return nodeIdNull;
    }

    @Override
    public final IllegalArgumentException nodeIdNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.nodeIdNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueNameIsNull$str() {
        return queueNameIsNull;
    }

    @Override
    public final IllegalArgumentException queueNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.queueNameIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindResource$str() {
        return cannotFindResource;
    }

    @Override
    public final IllegalArgumentException cannotFindResource(String resourceName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.cannotFindResource$str(), resourceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noGetterMethod$str() {
        return noGetterMethod;
    }

    @Override
    public final IllegalArgumentException noGetterMethod(String resourceName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.noGetterMethod$str(), resourceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noOperation$str() {
        return noOperation;
    }

    @Override
    public final IllegalArgumentException noOperation(String operation, Integer length) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.noOperation$str(), operation, length));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullMatch$str() {
        return nullMatch;
    }

    @Override
    public final IllegalArgumentException nullMatch() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.nullMatch$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMatch$str() {
        return invalidMatch;
    }

    @Override
    public final IllegalArgumentException invalidMatch() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidMatch$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullUser$str() {
        return nullUser;
    }

    @Override
    public final IllegalArgumentException nullUser() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.nullUser$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullPassword$str() {
        return nullPassword;
    }

    @Override
    public final IllegalArgumentException nullPassword() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.nullPassword$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCreatingTransformerClass$str() {
        return errorCreatingTransformerClass;
    }

    @Override
    public final IllegalArgumentException errorCreatingTransformerClass(Exception e, String transformerClassName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.errorCreatingTransformerClass$str(), transformerClassName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String autoConvertError$str() {
        return autoConvertError;
    }

    @Override
    public final IllegalArgumentException autoConvertError(Class<? extends Object> aClass) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.autoConvertError$str(), aClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String destroyConnectionWithSessionMetadataHeader$str() {
        return destroyConnectionWithSessionMetadataHeader;
    }

    @Override
    public final String destroyConnectionWithSessionMetadataHeader(String key, String value) {
        return MessageFormat.format(this.destroyConnectionWithSessionMetadataHeader$str(), key, value);
    }

    protected String destroyConnectionWithSessionMetadataClosingConnection$str() {
        return destroyConnectionWithSessionMetadataClosingConnection;
    }

    @Override
    public final String destroyConnectionWithSessionMetadataClosingConnection(String serverSessionString) {
        return MessageFormat.format(this.destroyConnectionWithSessionMetadataClosingConnection$str(), serverSessionString);
    }

    protected String destroyConnectionWithSessionMetadataSendException$str() {
        return destroyConnectionWithSessionMetadataSendException;
    }

    @Override
    public final ActiveMQDisconnectedException destroyConnectionWithSessionMetadataSendException(String key, String value) {
        ActiveMQDisconnectedException result = new ActiveMQDisconnectedException(MessageFormat.format(this.destroyConnectionWithSessionMetadataSendException$str(), key, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String destroyConnectionWithSessionMetadataNoSessionFound$str() {
        return destroyConnectionWithSessionMetadataNoSessionFound;
    }

    @Override
    public final String destroyConnectionWithSessionMetadataNoSessionFound(String key, String value) {
        return MessageFormat.format(this.destroyConnectionWithSessionMetadataNoSessionFound$str(), key, value);
    }

    protected String invalidPageIO$str() {
        return invalidPageIO;
    }

    @Override
    public final ActiveMQIllegalStateException invalidPageIO() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.invalidPageIO$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDiscoveryGroupFound$str() {
        return noDiscoveryGroupFound;
    }

    @Override
    public final ActiveMQException noDiscoveryGroupFound(DiscoveryGroupConfiguration dg) {
        ActiveMQException result = new ActiveMQException(MessageFormat.format(this.noDiscoveryGroupFound$str(), dg));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueSubscriptionBelongsToDifferentAddress$str() {
        return queueSubscriptionBelongsToDifferentAddress;
    }

    @Override
    public final ActiveMQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentAddress(SimpleString queueName) {
        ActiveMQInvalidTransientQueueUseException result = new ActiveMQInvalidTransientQueueUseException(MessageFormat.format(this.queueSubscriptionBelongsToDifferentAddress$str(), queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueSubscriptionBelongsToDifferentFilter$str() {
        return queueSubscriptionBelongsToDifferentFilter;
    }

    @Override
    public final ActiveMQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentFilter(SimpleString queueName) {
        ActiveMQInvalidTransientQueueUseException result = new ActiveMQInvalidTransientQueueUseException(MessageFormat.format(this.queueSubscriptionBelongsToDifferentFilter$str(), queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToValidateClusterUser$str() {
        return unableToValidateClusterUser;
    }

    @Override
    public final ActiveMQClusterSecurityException unableToValidateClusterUser(String user) {
        ActiveMQClusterSecurityException result = new ActiveMQClusterSecurityException(MessageFormat.format(this.unableToValidateClusterUser$str(), user));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String journalDirIsFile$str() {
        return journalDirIsFile;
    }

    @Override
    public final IllegalStateException journalDirIsFile(File fDir) {
        IllegalStateException result = new IllegalStateException(MessageFormat.format(this.journalDirIsFile$str(), fDir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotMoveJournal$str() {
        return couldNotMoveJournal;
    }

    @Override
    public final IllegalStateException couldNotMoveJournal(File dir) {
        IllegalStateException result = new IllegalStateException(MessageFormat.format(this.couldNotMoveJournal$str(), dir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String addressIsFull$str() {
        return addressIsFull;
    }

    @Override
    public final ActiveMQAddressFullException addressIsFull(String addressName) {
        ActiveMQAddressFullException result = new ActiveMQAddressFullException(MessageFormat.format(this.addressIsFull$str(), addressName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noConfigurationFoundForScaleDown$str() {
        return noConfigurationFoundForScaleDown;
    }

    @Override
    public final ActiveMQException noConfigurationFoundForScaleDown() {
        ActiveMQException result = new ActiveMQException(String.format(this.noConfigurationFoundForScaleDown$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String groupWhileStopping$str() {
        return groupWhileStopping;
    }

    @Override
    public final ActiveMQException groupWhileStopping() {
        ActiveMQException result = new ActiveMQException(String.format(this.groupWhileStopping$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSlowConsumerPolicyType$str() {
        return invalidSlowConsumerPolicyType;
    }

    @Override
    public final IllegalArgumentException invalidSlowConsumerPolicyType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidSlowConsumerPolicyType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String consumerConnectionsClosedByManagement$str() {
        return consumerConnectionsClosedByManagement;
    }

    @Override
    public final ActiveMQInternalErrorException consumerConnectionsClosedByManagement(String address) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(MessageFormat.format(this.consumerConnectionsClosedByManagement$str(), address));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionsForUserClosedByManagement$str() {
        return connectionsForUserClosedByManagement;
    }

    @Override
    public final ActiveMQInternalErrorException connectionsForUserClosedByManagement(String userName) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(MessageFormat.format(this.connectionsForUserClosedByManagement$str(), userName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedHAPolicyConfiguration$str() {
        return unsupportedHAPolicyConfiguration;
    }

    @Override
    public final ActiveMQIllegalStateException unsupportedHAPolicyConfiguration(Object o) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(MessageFormat.format(this.unsupportedHAPolicyConfiguration$str(), o));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sessionLimitReached$str() {
        return sessionLimitReached;
    }

    @Override
    public final ActiveMQSessionCreationException sessionLimitReached(String username, int limit) {
        ActiveMQSessionCreationException result = new ActiveMQSessionCreationException(MessageFormat.format(this.sessionLimitReached$str(), username, limit));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueLimitReached$str() {
        return queueLimitReached;
    }

    @Override
    public final ActiveMQSessionCreationException queueLimitReached(String username, int limit) {
        ActiveMQSessionCreationException result = new ActiveMQSessionCreationException(MessageFormat.format(this.queueLimitReached$str(), username, limit));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotSetMBeanserver$str() {
        return cannotSetMBeanserver;
    }

    @Override
    public final IllegalStateException cannotSetMBeanserver() {
        IllegalStateException result = new IllegalStateException(String.format(this.cannotSetMBeanserver$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMessageLoadBalancingType$str() {
        return invalidMessageLoadBalancingType;
    }

    @Override
    public final IllegalArgumentException invalidMessageLoadBalancingType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidMessageLoadBalancingType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationSynchronizationTimeout$str() {
        return replicationSynchronizationTimeout;
    }

    @Override
    public final IllegalStateException replicationSynchronizationTimeout(long timeout) {
        IllegalStateException result = new IllegalStateException(MessageFormat.format(this.replicationSynchronizationTimeout$str(), timeout));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String liveBackupMismatch$str() {
        return liveBackupMismatch;
    }

    @Override
    public final ActiveMQIllegalStateException liveBackupMismatch() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this.liveBackupMismatch$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String acceptorUnavailable$str() {
        return acceptorUnavailable;
    }

    @Override
    public final IllegalStateException acceptorUnavailable() {
        IllegalStateException result = new IllegalStateException(this.acceptorUnavailable$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicatorIsNull$str() {
        return replicatorIsNull;
    }

    @Override
    public final ActiveMQIllegalStateException replicatorIsNull() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.replicatorIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String methodNotApplicable$str() {
        return methodNotApplicable;
    }

    @Override
    public final IllegalStateException methodNotApplicable() {
        IllegalStateException result = new IllegalStateException(String.format(this.methodNotApplicable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String diskBeyondLimit$str() {
        return diskBeyondLimit;
    }

    @Override
    public final ActiveMQIOErrorException diskBeyondLimit() {
        ActiveMQIOErrorException result = new ActiveMQIOErrorException(String.format(this.diskBeyondLimit$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

