/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.metrics.ActiveMQMetricsPlugin;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;

public class MetricsManager {
    private final String brokerName;
    private final MeterRegistry meterRegistry;
    private final Map<String, List<Meter>> meters = new ConcurrentHashMap<String, List<Meter>>();
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;

    public MetricsManager(String brokerName, ActiveMQMetricsPlugin metricsPlugin, HierarchicalRepository<AddressSettings> addressSettingsRepository) {
        this.brokerName = brokerName;
        this.meterRegistry = metricsPlugin.getRegistry();
        Metrics.globalRegistry.add(this.meterRegistry);
        new JvmMemoryMetrics().bindTo(this.meterRegistry);
        this.addressSettingsRepository = addressSettingsRepository;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public void registerQueueGauge(String address, String queue, Consumer<MetricGaugeBuilder> builder) {
        MeterRegistry meterRegistry = this.meterRegistry;
        if (meterRegistry == null || !this.addressSettingsRepository.getMatch(address).isEnableMetrics()) {
            return;
        }
        ArrayList newMeters = new ArrayList();
        builder.accept((metricName, state, f, description) -> {
            Gauge.Builder meter = Gauge.builder((String)("artemis." + metricName), (Object)state, (ToDoubleFunction)f).tag("broker", this.brokerName).tag("address", address).tag("queue", queue).description(description);
            newMeters.add(meter);
        });
        String resource = "queue." + queue;
        this.meters.compute(resource, (s, meters) -> {
            meters = new ArrayList<Gauge>(newMeters.size());
            for (Gauge.Builder gauge : newMeters) {
                meters.add(gauge.register(meterRegistry));
            }
            return meters;
        });
    }

    public void registerAddressGauge(String address, Consumer<MetricGaugeBuilder> builder) {
        MeterRegistry meterRegistry = this.meterRegistry;
        if (meterRegistry == null || !this.addressSettingsRepository.getMatch(address).isEnableMetrics()) {
            return;
        }
        ArrayList newMeters = new ArrayList();
        builder.accept((metricName, state, f, description) -> {
            Gauge.Builder meter = Gauge.builder((String)("artemis." + metricName), (Object)state, (ToDoubleFunction)f).tag("broker", this.brokerName).tag("address", address).description(description);
            newMeters.add(meter);
        });
        String resource = "address." + address;
        this.meters.compute(resource, (s, meters) -> {
            meters = new ArrayList<Gauge>(newMeters.size());
            for (Gauge.Builder gauge : newMeters) {
                meters.add(gauge.register(meterRegistry));
            }
            return meters;
        });
    }

    public void registerBrokerGauge(Consumer<MetricGaugeBuilder> builder) {
        MeterRegistry meterRegistry = this.meterRegistry;
        if (meterRegistry == null) {
            return;
        }
        ArrayList newMeters = new ArrayList();
        builder.accept((metricName, state, f, description) -> {
            Gauge.Builder meter = Gauge.builder((String)("artemis." + metricName), (Object)state, (ToDoubleFunction)f).tag("broker", this.brokerName).description(description);
            newMeters.add(meter);
        });
        String resource = "broker." + this.brokerName;
        this.meters.compute(resource, (s, meters) -> {
            meters = new ArrayList<Gauge>(newMeters.size());
            for (Gauge.Builder gauge : newMeters) {
                meters.add(gauge.register(meterRegistry));
            }
            return meters;
        });
    }

    public void remove(String component) {
        this.meters.computeIfPresent(component, (s, meters) -> {
            if (meters == null) {
                return null;
            }
            for (Meter meter : meters) {
                Meter removed = this.meterRegistry.remove(meter);
                if (!ActiveMQServerLogger.LOGGER.isDebugEnabled()) continue;
                ActiveMQServerLogger.LOGGER.debug("Removed meter: " + removed.getId());
            }
            return null;
        });
    }

    @FunctionalInterface
    public static interface MetricGaugeBuilder {
        public void register(String var1, Object var2, ToDoubleFunction var3, String var4);
    }
}

