/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import com.google.common.base.Predicate;
import java.util.Collection;

public class ActiveMQFilterPredicate<T>
implements Predicate<T> {
    protected String field;
    protected String value;
    protected Operation operation;

    public static boolean contains(String field, String value) {
        return field.contains(value);
    }

    public boolean apply(T input) {
        return true;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        if (operation != null && !operation.equals("")) {
            this.operation = Operation.valueOf(operation);
        }
    }

    public boolean matches(Object field) {
        if (this.operation != null) {
            switch (this.operation) {
                case EQUALS: {
                    return this.equals(field, this.value);
                }
                case CONTAINS: {
                    return this.contains(field, this.value);
                }
            }
        }
        return true;
    }

    public boolean matchAny(Collection objects) {
        for (Object o : objects) {
            if (!this.matches(o)) continue;
            return true;
        }
        return false;
    }

    private boolean equals(Object field, Object value) {
        if (field == null) {
            return value.equals("") || value == null;
        }
        return field.toString().equals(value);
    }

    private boolean contains(Object field, Object value) {
        if (field == null) {
            return value.equals("") || value == null;
        }
        return field.toString().contains(value.toString());
    }

    static enum Operation {
        CONTAINS,
        EQUALS;

    }
}

