/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ChecksumApplet
extends Applet {
    private static final int CHECKSUM_BUFFER_SIZE = 8192;
    private static final int BYTE_MASK = 255;
    private JProgressBar progressBar;

    public void init() {
        this.setLayout(new BorderLayout());
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.add((Component)this.progressBar, "Center");
        JLabel label = new JLabel("Checksum progress: ");
        this.add((Component)label, "West");
    }

    public String generateMd5(final String file) throws IOException, NoSuchAlgorithmException {
        Object o = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return ChecksumApplet.this.checksumFile(file);
                }
                catch (NoSuchAlgorithmException e) {
                    return "Error checksumming file: " + e.getMessage();
                }
                catch (FileNotFoundException e) {
                    return "Couldn't find the file. " + e.getMessage();
                }
                catch (IOException e) {
                    return "Error reading file: " + e.getMessage();
                }
            }
        });
        return (String)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String checksumFile(String file) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        long total = new File(file).length();
        FileInputStream fis = new FileInputStream(file);
        try {
            int numRead;
            long totalRead = 0L;
            byte[] buffer = new byte[8192];
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                digest.update(buffer, 0, numRead);
                this.progressBar.setValue((int)((totalRead += (long)numRead) * (long)this.progressBar.getMaximum() / total));
            } while (numRead != -1);
        }
        finally {
            ((InputStream)fis).close();
        }
        return ChecksumApplet.byteArrayToHexStr(digest.digest());
    }

    protected static String byteArrayToHexStr(byte[] data) {
        String output = "";
        for (int cnt = 0; cnt < data.length; ++cnt) {
            int tempInt = data[cnt] & 0xFF;
            String tempStr = Integer.toHexString(tempInt);
            if (tempStr.length() == 1) {
                tempStr = "0" + tempStr;
            }
            output = output + tempStr;
        }
        return output.toUpperCase();
    }
}

