/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.reporting.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.ConfigurationNames;
import org.apache.maven.archiva.configuration.FileTypes;
import org.apache.maven.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.maven.archiva.consumers.ArchivaArtifactConsumer;
import org.apache.maven.archiva.consumers.ConsumerException;
import org.apache.maven.archiva.database.ArchivaDAO;
import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.ObjectNotFoundException;
import org.apache.maven.archiva.database.constraints.ArtifactsByChecksumConstraint;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.model.RepositoryProblem;
import org.apache.maven.archiva.repository.ManagedRepositoryContent;
import org.apache.maven.archiva.repository.RepositoryContentFactory;
import org.apache.maven.archiva.repository.RepositoryException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.registry.Registry;
import org.codehaus.plexus.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateArtifactsConsumer
extends AbstractMonitoredConsumer
implements ArchivaArtifactConsumer,
RegistryListener,
Initializable {
    private Logger log = LoggerFactory.getLogger(DuplicateArtifactsConsumer.class);
    private String id;
    private String description;
    private ArchivaConfiguration configuration;
    private FileTypes filetypes;
    private ArchivaDAO dao;
    private RepositoryContentFactory repositoryFactory;
    private List<String> includes = new ArrayList<String>();

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isPermanent() {
        return false;
    }

    public void beginScan() {
    }

    public void completeScan() {
    }

    public List<String> getIncludedTypes() {
        return null;
    }

    public void processArchivaArtifact(ArchivaArtifact artifact) throws ConsumerException {
        String checksumSha1 = artifact.getModel().getChecksumSHA1();
        List results = null;
        try {
            results = this.dao.getArtifactDAO().queryArtifacts((Constraint)new ArtifactsByChecksumConstraint(checksumSha1, "SHA1"));
        }
        catch (ObjectNotFoundException e) {
            this.log.debug("No duplicates for artifact: " + artifact);
            return;
        }
        catch (ArchivaDatabaseException e) {
            this.log.warn("Unable to query DB for potential duplicates with : " + artifact);
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            if (results.size() <= 1) {
                this.log.debug("Found no duplicate artifact results on: " + artifact);
                return;
            }
            for (ArchivaArtifact dupArtifact : results) {
                if (dupArtifact.equals((Object)artifact)) continue;
                RepositoryProblem problem = new RepositoryProblem();
                problem.setRepositoryId(dupArtifact.getModel().getRepositoryId());
                problem.setPath(this.toPath(dupArtifact));
                problem.setGroupId(artifact.getGroupId());
                problem.setArtifactId(artifact.getArtifactId());
                problem.setVersion(artifact.getVersion());
                problem.setType("duplicate-artifacts");
                problem.setOrigin(this.getId());
                problem.setMessage("Duplicate Artifact Detected: " + artifact + " <--> " + dupArtifact);
                try {
                    this.log.debug("Found duplicate artifact: " + problem);
                    this.dao.getRepositoryProblemDAO().saveRepositoryProblem(problem);
                }
                catch (ArchivaDatabaseException e) {
                    String emsg = "Unable to save problem with duplicate artifact to DB: " + e.getMessage();
                    this.log.warn(emsg, (Throwable)e);
                    throw new ConsumerException(emsg, (Throwable)e);
                }
            }
        }
    }

    private String toPath(ArchivaArtifact artifact) {
        try {
            String repoId = artifact.getModel().getRepositoryId();
            ManagedRepositoryContent repo = this.repositoryFactory.getManagedRepositoryContent(repoId);
            return repo.toPath(artifact);
        }
        catch (RepositoryException e) {
            this.log.warn("Unable to calculate path for artifact: " + artifact);
            return "";
        }
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isRepositoryScanning((String)propertyName)) {
            this.initIncludes();
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    private void initIncludes() {
        this.includes.clear();
        this.includes.addAll(this.filetypes.getFileTypePatterns("artifacts"));
    }

    public void initialize() throws InitializationException {
        this.initIncludes();
        this.configuration.addChangeListener((RegistryListener)this);
    }
}

