/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.reporting.artifact;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.ConfigurationNames;
import org.apache.maven.archiva.configuration.FileTypes;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.maven.archiva.consumers.ArchivaArtifactConsumer;
import org.apache.maven.archiva.consumers.ConsumerException;
import org.apache.maven.archiva.database.ArchivaDAO;
import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.model.ArchivaProjectModel;
import org.apache.maven.archiva.model.RepositoryProblem;
import org.apache.maven.archiva.repository.ManagedRepositoryContent;
import org.apache.maven.archiva.repository.RepositoryContentFactory;
import org.apache.maven.archiva.repository.RepositoryException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.registry.Registry;
import org.codehaus.plexus.registry.RegistryListener;
import org.codehaus.plexus.util.SelectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationArtifactsConsumer
extends AbstractMonitoredConsumer
implements ArchivaArtifactConsumer,
RegistryListener,
Initializable {
    private Logger log = LoggerFactory.getLogger(LocationArtifactsConsumer.class);
    private String id;
    private String description;
    private ArchivaConfiguration configuration;
    private FileTypes filetypes;
    private ArchivaDAO dao;
    private RepositoryContentFactory repositoryFactory;
    private Map repositoryMap = new HashMap();
    private List<String> includes = new ArrayList<String>();

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isPermanent() {
        return false;
    }

    public void beginScan() {
    }

    public void completeScan() {
    }

    public List getIncludedTypes() {
        return null;
    }

    public void processArchivaArtifact(ArchivaArtifact artifact) throws ConsumerException {
        ManagedRepositoryConfiguration repository = this.findRepository(artifact);
        File artifactFile = new File(repository.getLocation(), this.toPath(artifact));
        ArchivaProjectModel fsModel = this.readFilesystemModel(artifactFile);
        ArchivaProjectModel embeddedModel = this.readEmbeddedModel(artifact, artifactFile);
        this.validateAppropriateModel("Filesystem", artifact, fsModel);
        this.validateAppropriateModel("Embedded", artifact, embeddedModel);
    }

    private void validateAppropriateModel(String location, ArchivaArtifact artifact, ArchivaProjectModel model) throws ConsumerException {
        if (model != null) {
            if (!StringUtils.equals((String)model.getGroupId(), (String)artifact.getGroupId())) {
                this.addProblem(artifact, "The groupId of the " + location + " project model doesn't match with the artifact, expected <" + artifact.getGroupId() + ">, but was actually <" + model.getGroupId() + ">");
            }
            if (!StringUtils.equals((String)model.getArtifactId(), (String)artifact.getArtifactId())) {
                this.addProblem(artifact, "The artifactId of the " + location + " project model doesn't match with the artifact, expected <" + artifact.getArtifactId() + ">, but was actually <" + model.getArtifactId() + ">");
            }
            if (!StringUtils.equals((String)model.getVersion(), (String)artifact.getVersion())) {
                this.addProblem(artifact, "The version of the " + location + " project model doesn't match with the artifact, expected <" + artifact.getVersion() + ">, but was actually <" + model.getVersion() + ">");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArchivaProjectModel readEmbeddedModel(ArchivaArtifact artifact, File artifactFile) throws ConsumerException {
        try {
            JarFile jar = new JarFile(artifactFile);
            JarEntry expectedEntry = jar.getJarEntry("META-INF/maven/" + artifact.getGroupId() + "/" + artifact.getArtifactId() + "/pom.xml");
            if (expectedEntry != null) {
                return null;
            }
            List<JarEntry> actualPomXmls = this.findJarEntryPattern(jar, "META-INF/maven/**/pom.xml");
            if (!actualPomXmls.isEmpty()) return null;
        }
        catch (IOException e) {
            String emsg = "Unable to read file contents: " + e.getMessage();
            this.addProblem(artifact, emsg);
        }
        return null;
    }

    private List<JarEntry> findJarEntryPattern(JarFile jar, String pattern) {
        ArrayList<JarEntry> hits = new ArrayList<JarEntry>();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!SelectorUtils.match((String)pattern, (String)entry.getName())) continue;
            hits.add(entry);
        }
        return hits;
    }

    private void addProblem(ArchivaArtifact artifact, String msg) throws ConsumerException {
        RepositoryProblem problem = new RepositoryProblem();
        problem.setRepositoryId(artifact.getModel().getRepositoryId());
        problem.setPath(this.toPath(artifact));
        problem.setGroupId(artifact.getGroupId());
        problem.setArtifactId(artifact.getArtifactId());
        problem.setVersion(artifact.getVersion());
        problem.setType("bad-artifact-location");
        problem.setOrigin(this.getId());
        problem.setMessage(msg);
        try {
            this.dao.getRepositoryProblemDAO().saveRepositoryProblem(problem);
        }
        catch (ArchivaDatabaseException e) {
            String emsg = "Unable to save problem with artifact location to DB: " + e.getMessage();
            this.log.warn(emsg, (Throwable)e);
            throw new ConsumerException(emsg, (Throwable)e);
        }
    }

    private ArchivaProjectModel readFilesystemModel(File artifactFile) {
        File pomFile = this.createPomFileReference(artifactFile);
        return null;
    }

    private File createPomFileReference(File artifactFile) {
        String pomFilename = artifactFile.getAbsolutePath();
        int pos = pomFilename.lastIndexOf(46);
        if (pos <= 0) {
            return null;
        }
        pomFilename = pomFilename.substring(0, pos) + ".pom";
        return new File(pomFilename);
    }

    private ManagedRepositoryConfiguration findRepository(ArchivaArtifact artifact) {
        return (ManagedRepositoryConfiguration)this.repositoryMap.get(artifact.getModel().getRepositoryId());
    }

    private String toPath(ArchivaArtifact artifact) {
        try {
            String repoId = artifact.getModel().getRepositoryId();
            ManagedRepositoryContent repo = this.repositoryFactory.getManagedRepositoryContent(repoId);
            return repo.toPath(artifact);
        }
        catch (RepositoryException e) {
            this.log.warn("Unable to calculate path for artifact: " + artifact);
            return "";
        }
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isManagedRepositories((String)propertyName)) {
            this.initRepositoryMap();
        }
        if (ConfigurationNames.isRepositoryScanning((String)propertyName)) {
            this.initIncludes();
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    private void initIncludes() {
        this.includes.clear();
        this.includes.addAll(this.filetypes.getFileTypePatterns("artifacts"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepositoryMap() {
        Map map = this.repositoryMap;
        synchronized (map) {
            this.repositoryMap.clear();
            Map map2 = this.configuration.getConfiguration().getManagedRepositoriesAsMap();
            for (Map.Entry entry : map2.entrySet()) {
                this.repositoryMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public void initialize() throws InitializationException {
        this.initRepositoryMap();
        this.initIncludes();
        this.configuration.addChangeListener((RegistryListener)this);
    }
}

