/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.checksum;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.archiva.checksum.Checksum;
import org.apache.archiva.checksum.ChecksumAlgorithm;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksummedFile {
    private Logger log = LoggerFactory.getLogger(ChecksummedFile.class);
    private final File referenceFile;

    public ChecksummedFile(File referenceFile) {
        this.referenceFile = referenceFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String calculateChecksum(ChecksumAlgorithm checksumAlgorithm) throws IOException {
        String string;
        FileInputStream fis = null;
        try {
            Checksum checksum = new Checksum(checksumAlgorithm);
            fis = new FileInputStream(this.referenceFile);
            checksum.update(fis);
            string = checksum.getChecksum();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
        return string;
    }

    public File createChecksum(ChecksumAlgorithm checksumAlgorithm) throws IOException {
        File checksumFile = new File(this.referenceFile.getAbsolutePath() + "." + checksumAlgorithm.getExt());
        String checksum = this.calculateChecksum(checksumAlgorithm);
        FileUtils.writeStringToFile((File)checksumFile, (String)(checksum + "  " + this.referenceFile.getName()));
        return checksumFile;
    }

    public File getChecksumFile(ChecksumAlgorithm checksumAlgorithm) {
        return new File(this.referenceFile.getAbsolutePath() + "." + checksumAlgorithm.getExt());
    }

    public boolean isValidChecksum(ChecksumAlgorithm algorithm) throws IOException {
        return this.isValidChecksums(new ChecksumAlgorithm[]{algorithm});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidChecksums(ChecksumAlgorithm[] algorithms) {
        boolean valid;
        File checksumFile;
        ArrayList<Checksum> checksums;
        FileInputStream fis;
        block11: {
            fis = null;
            checksums = new ArrayList<Checksum>();
            for (ChecksumAlgorithm checksumAlgorithm : algorithms) {
                checksumFile = this.getChecksumFile(checksumAlgorithm);
                if (!checksumFile.exists()) continue;
                checksums.add(new Checksum(checksumAlgorithm));
            }
            if (!checksums.isEmpty()) break block11;
            boolean arr$ = false;
            IOUtils.closeQuietly(fis);
            return arr$;
        }
        try {
            fis = new FileInputStream(this.referenceFile);
            Checksum.update(checksums, fis);
        }
        catch (IOException e) {
            this.log.warn("Unable to update checksum:" + e.getMessage());
            int len$ = 0;
            IOUtils.closeQuietly((InputStream)fis);
            return len$ != 0;
        }
        try {
            valid = true;
            try {
                for (Checksum checksum : checksums) {
                    ChecksumAlgorithm checksumAlgorithm;
                    checksumAlgorithm = checksum.getAlgorithm();
                    checksumFile = this.getChecksumFile(checksumAlgorithm);
                    String rawChecksum = FileUtils.readFileToString((File)checksumFile);
                    String expectedChecksum = this.parseChecksum(rawChecksum, checksumAlgorithm, this.referenceFile.getName());
                    if (StringUtils.equalsIgnoreCase((String)expectedChecksum, (String)checksum.getChecksum())) continue;
                    valid = false;
                }
            }
            catch (IOException e) {
                this.log.warn("Unable to read / parse checksum: " + e.getMessage());
                boolean bl = false;
                IOUtils.closeQuietly((InputStream)fis);
                return bl;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        boolean bl = valid;
        IOUtils.closeQuietly((InputStream)fis);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fixChecksums(ChecksumAlgorithm[] algorithms) {
        ArrayList<Checksum> checksums = new ArrayList<Checksum>();
        for (ChecksumAlgorithm checksumAlgorithm : algorithms) {
            checksums.add(new Checksum(checksumAlgorithm));
        }
        if (checksums.isEmpty()) {
            return true;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.referenceFile);
            Checksum.update(checksums, fis);
        }
        catch (IOException e) {
            int i$;
            try {
                this.log.warn(e.getMessage(), (Throwable)e);
                i$ = 0;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            return i$ != 0;
        }
        IOUtils.closeQuietly((InputStream)fis);
        boolean valid = true;
        for (Checksum checksum : checksums) {
            ChecksumAlgorithm checksumAlgorithm = checksum.getAlgorithm();
            try {
                File checksumFile = this.getChecksumFile(checksumAlgorithm);
                String actualChecksum = checksum.getChecksum();
                if (checksumFile.exists()) {
                    String rawChecksum = FileUtils.readFileToString((File)checksumFile);
                    String expectedChecksum = this.parseChecksum(rawChecksum, checksumAlgorithm, this.referenceFile.getName());
                    if (StringUtils.equalsIgnoreCase((String)expectedChecksum, (String)actualChecksum)) continue;
                    FileUtils.writeStringToFile((File)checksumFile, (String)(actualChecksum + "  " + this.referenceFile.getName()));
                    continue;
                }
                FileUtils.writeStringToFile((File)checksumFile, (String)(actualChecksum + "  " + this.referenceFile.getName()));
            }
            catch (IOException e) {
                this.log.warn(e.getMessage(), (Throwable)e);
                valid = false;
            }
        }
        return valid;
    }

    private boolean isValidChecksumPattern(String filename, String path) {
        Pattern pattern = Pattern.compile("maven-metadata-\\S*.xml");
        Matcher m = pattern.matcher(path);
        if (m.matches()) {
            return filename.endsWith(path) || "-".equals(filename) || filename.endsWith("maven-metadata.xml");
        }
        return filename.endsWith(path) || "-".equals(filename);
    }

    public String parseChecksum(String rawChecksumString, ChecksumAlgorithm expectedHash, String expectedPath) throws IOException {
        String trimmedChecksum = rawChecksumString.replace('\n', ' ').trim();
        String regex = expectedHash.getType() + "\\s*\\(([^)]*)\\)\\s*=\\s*([a-fA-F0-9]+)";
        Matcher m = Pattern.compile(regex).matcher(trimmedChecksum);
        if (m.matches()) {
            String filename = m.group(1);
            if (!this.isValidChecksumPattern(filename, expectedPath)) {
                throw new IOException("Supplied checksum file '" + filename + "' does not match expected file: '" + expectedPath + "'");
            }
            trimmedChecksum = m.group(2);
        } else {
            m = Pattern.compile("([a-fA-F0-9]+)\\s+\\*?(.+)").matcher(trimmedChecksum);
            if (m.matches()) {
                String filename = m.group(2);
                if (!this.isValidChecksumPattern(filename, expectedPath)) {
                    throw new IOException("Supplied checksum file '" + filename + "' does not match expected file: '" + expectedPath + "'");
                }
                trimmedChecksum = m.group(1);
            }
        }
        return trimmedChecksum;
    }
}

