/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.checksum;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.archiva.checksum.ChecksumAlgorithm;
import org.apache.archiva.checksum.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;

public class Checksum {
    private static final int BUFFER_SIZE = 32768;
    protected final MessageDigest md;
    private ChecksumAlgorithm checksumAlgorithm;

    public static void update(List<Checksum> checksums, InputStream stream) throws IOException {
        byte[] buffer = new byte[32768];
        int size = stream.read(buffer, 0, 32768);
        while (size >= 0) {
            for (Checksum checksum : checksums) {
                checksum.update(buffer, 0, size);
            }
            size = stream.read(buffer, 0, 32768);
        }
    }

    public Checksum(ChecksumAlgorithm checksumAlgorithm) {
        this.checksumAlgorithm = checksumAlgorithm;
        try {
            this.md = MessageDigest.getInstance(checksumAlgorithm.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to initialize MessageDigest algorithm " + checksumAlgorithm.getAlgorithm() + " : " + e.getMessage(), e);
        }
    }

    public String getChecksum() {
        return Hex.encode(this.md.digest());
    }

    public ChecksumAlgorithm getAlgorithm() {
        return this.checksumAlgorithm;
    }

    public void reset() {
        this.md.reset();
    }

    public Checksum update(byte[] buffer, int offset, int size) {
        this.md.update(buffer, 0, size);
        return this;
    }

    public Checksum update(InputStream stream) throws IOException {
        DigestInputStream dig = new DigestInputStream(stream, this.md);
        IOUtils.copy((InputStream)dig, (OutputStream)new NullOutputStream());
        return this;
    }
}

