/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.cli;

import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.consumers.ConsumerException;
import org.apache.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.archiva.consumers.RepositoryContentConsumer;
import org.apache.archiva.converter.RepositoryConversionException;
import org.apache.archiva.converter.legacy.LegacyRepositoryConverter;
import org.apache.archiva.repository.scanner.RepositoryScanStatistics;
import org.apache.archiva.repository.scanner.RepositoryScanner;
import org.apache.archiva.repository.scanner.RepositoryScannerException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.manager.WagonManager;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchivaCli {
    public static final String SOURCE_REPO_PATH = "sourceRepositoryPath";
    public static final String TARGET_REPO_PATH = "targetRepositoryPath";
    public static final String BLACKLISTED_PATTERNS = "blacklistPatterns";
    public static final String POM_PROPERTIES = "/META-INF/maven/org.apache.archiva/archiva-cli/pom.properties";
    private ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(new String[]{"classpath*:/META-INF/spring-context.xml"});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersion() throws IOException {
        InputStream pomStream = ArchivaCli.class.getResourceAsStream(POM_PROPERTIES);
        if (pomStream == null) {
            throw new IOException("Failed to load /META-INF/maven/org.apache.archiva/archiva-cli/pom.properties");
        }
        try {
            Properties properties = new Properties();
            properties.load(pomStream);
            String string = properties.getProperty("version");
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)pomStream);
        }
    }

    public static void main(String[] args) throws Exception {
        Commands command = new Commands();
        try {
            Args.parse((Object)command, (String[])args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            Args.usage((Object)command);
            return;
        }
        new ArchivaCli().execute(command);
    }

    private void execute(Commands command) throws Exception {
        if (command.help) {
            Args.usage((Object)command);
        } else if (command.version) {
            System.out.print("Version: " + ArchivaCli.getVersion());
        } else if (command.convert) {
            this.doConversion(command.properties);
        } else if (command.scan) {
            if (command.repository == null) {
                System.err.println("The repository must be specified.");
                Args.usage((Object)command);
                return;
            }
            this.doScan(command.repository, command.consumers.split(","));
        } else if (command.listConsumers) {
            this.dumpAvailableConsumers();
        } else {
            Args.usage((Object)command);
        }
    }

    private void doScan(String path, String[] consumers) throws ConsumerException, MalformedURLException, PlexusSisuBridgeException {
        PlexusSisuBridge plexusSisuBridge = (PlexusSisuBridge)this.applicationContext.getBean(PlexusSisuBridge.class);
        WagonManager wagonManager = (WagonManager)plexusSisuBridge.lookup(WagonManager.class);
        wagonManager.addMirror("internal", "*", new File(path).toURL().toExternalForm());
        ManagedRepository repo = new ManagedRepository();
        repo.setId("cliRepo");
        repo.setName("Archiva CLI Provided Repo");
        repo.setLocation(path);
        ArrayList<KnownRepositoryContentConsumer> knownConsumerList = new ArrayList<KnownRepositoryContentConsumer>();
        knownConsumerList.addAll(this.getConsumerList(consumers));
        List invalidConsumerList = Collections.emptyList();
        ArrayList<String> ignoredContent = new ArrayList<String>();
        ignoredContent.addAll(Arrays.asList(RepositoryScanner.IGNORABLE_CONTENT));
        RepositoryScanner scanner = (RepositoryScanner)this.lookup(RepositoryScanner.class);
        try {
            RepositoryScanStatistics stats = scanner.scan(repo, knownConsumerList, invalidConsumerList, ignoredContent, 0L);
            System.out.println("\n" + stats.toDump(repo));
        }
        catch (RepositoryScannerException e) {
            e.printStackTrace(System.err);
        }
    }

    private Object lookup(Class<?> clazz) throws PlexusSisuBridgeException {
        PlexusSisuBridge plexusSisuBridge = (PlexusSisuBridge)this.applicationContext.getBean(PlexusSisuBridge.class);
        return plexusSisuBridge.lookup(clazz);
    }

    private List<KnownRepositoryContentConsumer> getConsumerList(String[] consumers) throws ConsumerException, PlexusSisuBridgeException {
        ArrayList<KnownRepositoryContentConsumer> consumerList = new ArrayList<KnownRepositoryContentConsumer>();
        Map<String, KnownRepositoryContentConsumer> availableConsumers = this.getConsumers();
        for (String specifiedConsumer : consumers) {
            if (!availableConsumers.containsKey(specifiedConsumer)) {
                System.err.println("Specified consumer [" + specifiedConsumer + "] not found.");
                this.dumpAvailableConsumers();
                System.exit(1);
            }
            consumerList.add(availableConsumers.get(specifiedConsumer));
        }
        return consumerList;
    }

    private void dumpAvailableConsumers() throws PlexusSisuBridgeException {
        Map<String, KnownRepositoryContentConsumer> availableConsumers = this.getConsumers();
        System.out.println(".\\ Available Consumer List \\.______________________________");
        for (Map.Entry<String, KnownRepositoryContentConsumer> entry : availableConsumers.entrySet()) {
            String consumerHint = entry.getKey();
            RepositoryContentConsumer consumer = (RepositoryContentConsumer)entry.getValue();
            System.out.println("  " + consumerHint + ": " + consumer.getDescription() + " (" + consumer.getClass().getName() + ")");
        }
    }

    private Map<String, KnownRepositoryContentConsumer> getConsumers() throws PlexusSisuBridgeException {
        Map beans = this.applicationContext.getBeansOfType(KnownRepositoryContentConsumer.class);
        HashMap<String, KnownRepositoryContentConsumer> smallNames = new HashMap<String, KnownRepositoryContentConsumer>(beans.size());
        for (Map.Entry entry : beans.entrySet()) {
            smallNames.put(StringUtils.substringAfterLast((String)((String)entry.getKey()), (String)"#"), (KnownRepositoryContentConsumer)entry.getValue());
        }
        return smallNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion(String properties) throws FileNotFoundException, IOException, RepositoryConversionException, PlexusSisuBridgeException {
        LegacyRepositoryConverter legacyRepositoryConverter = (LegacyRepositoryConverter)this.lookup(LegacyRepositoryConverter.class);
        Properties p = new Properties();
        FileInputStream fis = new FileInputStream(properties);
        try {
            p.load(fis);
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
        File oldRepositoryPath = new File(p.getProperty(SOURCE_REPO_PATH));
        File newRepositoryPath = new File(p.getProperty(TARGET_REPO_PATH));
        System.out.println("Converting " + oldRepositoryPath + " to " + newRepositoryPath);
        List<String> fileExclusionPatterns = null;
        String s = p.getProperty(BLACKLISTED_PATTERNS);
        if (s != null) {
            fileExclusionPatterns = Arrays.asList(StringUtils.split((String)s, (String)","));
        }
        legacyRepositoryConverter.convertLegacyRepository(oldRepositoryPath, newRepositoryPath, fileExclusionPatterns);
    }

    private static class Commands {
        @Argument(description="Display help information", value="help", alias="h")
        private boolean help;
        @Argument(description="Display version information", value="version", alias="v")
        private boolean version;
        @Argument(description="List available consumers", value="listconsumers", alias="l")
        private boolean listConsumers;
        @Argument(description="The consumers to use (comma delimited)", value="consumers", alias="u")
        private String consumers = "count-artifacts";
        @Argument(description="Scan the specified repository", value="scan", alias="s")
        private boolean scan;
        @Argument(description="Convert a legacy Maven 1.x repository to a Maven 2.x repository using a properties file to describe the conversion", value="convert", alias="c")
        private boolean convert;
        @Argument(description="The properties file for the conversion", value="properties")
        private String properties = "conversion.properties";
        @Argument(description="The repository to scan", value="repository")
        private String repository;

        private Commands() {
        }
    }
}

