/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.converter.legacy;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.maven.archiva.consumers.ConsumerException;
import org.apache.maven.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.maven.archiva.converter.artifact.ArtifactConversionException;
import org.apache.maven.archiva.converter.artifact.ArtifactConverter;
import org.apache.maven.archiva.model.ArtifactReference;
import org.apache.maven.archiva.repository.ManagedRepositoryContent;
import org.apache.maven.archiva.repository.content.ManagedDefaultRepositoryContent;
import org.apache.maven.archiva.repository.layout.LayoutException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyConverterArtifactConsumer
extends AbstractMonitoredConsumer
implements KnownRepositoryContentConsumer {
    private Logger log = LoggerFactory.getLogger(LegacyConverterArtifactConsumer.class);
    private ArtifactConverter artifactConverter;
    private ArtifactFactory artifactFactory;
    private ManagedRepositoryContent managedRepository;
    private ArtifactRepository destinationRepository;
    private List<String> includes = new ArrayList<String>();
    private List<String> excludes;

    public LegacyConverterArtifactConsumer() {
        this.includes.add("**/*.jar");
        this.includes.add("**/*.ear");
        this.includes.add("**/*.war");
    }

    public void beginScan(ManagedRepositoryConfiguration repository, Date whenGathered) throws ConsumerException {
        this.managedRepository = new ManagedDefaultRepositoryContent();
        this.managedRepository.setRepository(repository);
    }

    public void completeScan() {
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void processFile(String path) throws ConsumerException {
        try {
            ArtifactReference reference = this.managedRepository.toArtifactReference(path);
            Artifact artifact = this.artifactFactory.createArtifact(reference.getGroupId(), reference.getArtifactId(), reference.getVersion(), reference.getClassifier(), reference.getType());
            this.artifactConverter.convert(artifact, this.destinationRepository);
        }
        catch (LayoutException e) {
            this.log.warn("Unable to convert artifact: " + path + " : " + e.getMessage(), (Throwable)e);
        }
        catch (ArtifactConversionException e) {
            this.log.warn("Unable to convert artifact: " + path + " : " + e.getMessage(), (Throwable)e);
        }
    }

    public String getDescription() {
        return "Legacy Artifact to Default Artifact Converter";
    }

    public String getId() {
        return "artifact-legacy-to-default-converter";
    }

    public boolean isPermanent() {
        return false;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public ArtifactRepository getDestinationRepository() {
        return this.destinationRepository;
    }

    public void setDestinationRepository(ArtifactRepository destinationRepository) {
        this.destinationRepository = destinationRepository;
    }
}

