/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.converter.legacy;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.archiva.common.utils.PathUtil;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.converter.RepositoryConversionException;
import org.apache.maven.archiva.converter.legacy.LegacyConverterArtifactConsumer;
import org.apache.maven.archiva.converter.legacy.LegacyRepositoryConverter;
import org.apache.maven.archiva.repository.RepositoryException;
import org.apache.maven.archiva.repository.scanner.RepositoryScanner;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLegacyRepositoryConverter
implements LegacyRepositoryConverter {
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactRepositoryLayout defaultLayout;
    private LegacyConverterArtifactConsumer legacyConverterConsumer;
    private RepositoryScanner repoScanner;

    @Override
    public void convertLegacyRepository(File legacyRepositoryDirectory, File repositoryDirectory, List<String> fileExclusionPatterns) throws RepositoryConversionException {
        try {
            String defaultRepositoryUrl = PathUtil.toUrl((File)repositoryDirectory);
            ManagedRepositoryConfiguration legacyRepository = new ManagedRepositoryConfiguration();
            legacyRepository.setId("legacy");
            legacyRepository.setName("Legacy Repository");
            legacyRepository.setLocation(legacyRepositoryDirectory.getAbsolutePath());
            legacyRepository.setLayout("legacy");
            ArtifactRepository repository = this.artifactRepositoryFactory.createArtifactRepository("default", defaultRepositoryUrl, this.defaultLayout, null, null);
            this.legacyConverterConsumer.setExcludes(fileExclusionPatterns);
            this.legacyConverterConsumer.setDestinationRepository(repository);
            ArrayList<LegacyConverterArtifactConsumer> knownConsumers = new ArrayList<LegacyConverterArtifactConsumer>();
            knownConsumers.add(this.legacyConverterConsumer);
            List invalidConsumers = Collections.emptyList();
            ArrayList<String> ignoredContent = new ArrayList<String>();
            ignoredContent.addAll(Arrays.asList(RepositoryScanner.IGNORABLE_CONTENT));
            this.repoScanner.scan(legacyRepository, knownConsumers, invalidConsumers, ignoredContent, 0L);
        }
        catch (RepositoryException e) {
            throw new RepositoryConversionException("Error convering legacy repository.", e);
        }
    }
}

