/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.converter.artifact;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.archiva.common.plexusbridge.DigesterUtils;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.converter.artifact.ArtifactConversionException;
import org.apache.archiva.converter.artifact.ArtifactConverter;
import org.apache.archiva.converter.artifact.Messages;
import org.apache.archiva.transaction.FileTransaction;
import org.apache.archiva.transaction.TransactionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.converter.ModelConverter;
import org.apache.maven.model.converter.PomTranslationException;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.v3_0_0.Model;
import org.apache.maven.model.v3_0_0.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.springframework.stereotype.Service;

@Service(value="artifactConverter#legacy-to-default")
public class LegacyToDefaultConverter
implements ArtifactConverter {
    private List<? extends Digester> digesters;
    @Inject
    private PlexusSisuBridge plexusSisuBridge;
    @Inject
    private DigesterUtils digesterUtils;
    private ModelConverter translator;
    private ArtifactFactory artifactFactory;
    private ArtifactHandlerManager artifactHandlerManager;
    private boolean force;
    private boolean dryrun;
    private Map<Artifact, List<String>> warnings = new HashMap<Artifact, List<String>>();

    @PostConstruct
    public void initialize() throws PlexusSisuBridgeException {
        this.digesters = this.digesterUtils.getAllDigesters();
        this.translator = (ModelConverter)this.plexusSisuBridge.lookup(ModelConverter.class);
        this.artifactFactory = (ArtifactFactory)this.plexusSisuBridge.lookup(ArtifactFactory.class);
        this.artifactHandlerManager = (ArtifactHandlerManager)this.plexusSisuBridge.lookup(ArtifactHandlerManager.class);
    }

    @Override
    public void convert(Artifact artifact, ArtifactRepository targetRepository) throws ArtifactConversionException {
        if (artifact.getRepository().getUrl().equals(targetRepository.getUrl())) {
            throw new ArtifactConversionException(Messages.getString("exception.repositories.match"));
        }
        if (!this.validateMetadata(artifact)) {
            this.addWarning(artifact, Messages.getString("unable.to.validate.metadata"));
            return;
        }
        FileTransaction transaction = new FileTransaction();
        if (!this.copyPom(artifact, targetRepository, transaction)) {
            this.addWarning(artifact, Messages.getString("unable.to.copy.pom"));
            return;
        }
        if (!this.copyArtifact(artifact, targetRepository, transaction)) {
            this.addWarning(artifact, Messages.getString("unable.to.copy.artifact"));
            return;
        }
        Metadata metadata = this.createBaseMetadata(artifact);
        Versioning versioning = new Versioning();
        versioning.addVersion(artifact.getBaseVersion());
        metadata.setVersioning(versioning);
        this.updateMetadata((RepositoryMetadata)new ArtifactRepositoryMetadata(artifact), targetRepository, metadata, transaction);
        metadata = this.createBaseMetadata(artifact);
        metadata.setVersion(artifact.getBaseVersion());
        versioning = new Versioning();
        Matcher matcher = Artifact.VERSION_FILE_PATTERN.matcher(artifact.getVersion());
        if (matcher.matches()) {
            Snapshot snapshot = new Snapshot();
            snapshot.setBuildNumber(Integer.parseInt(matcher.group(3)));
            snapshot.setTimestamp(matcher.group(2));
            versioning.setSnapshot(snapshot);
        }
        metadata.setVersioning(versioning);
        this.updateMetadata((RepositoryMetadata)new SnapshotArtifactRepositoryMetadata(artifact), targetRepository, metadata, transaction);
        if (!this.dryrun) {
            try {
                transaction.commit();
            }
            catch (TransactionException e) {
                throw new ArtifactConversionException(Messages.getString("transaction.failure", e.getMessage()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyPom(Artifact artifact, ArtifactRepository targetRepository, FileTransaction transaction) throws ArtifactConversionException {
        Artifact pom = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        pom.setBaseVersion(artifact.getBaseVersion());
        ArtifactRepository repository = artifact.getRepository();
        File file = new File(repository.getBasedir(), repository.pathOf(pom));
        boolean result = true;
        if (!file.exists()) {
            this.addWarning(artifact, Messages.getString("warning.missing.pom"));
            return result;
        }
        File targetFile = new File(targetRepository.getBasedir(), targetRepository.pathOf(pom));
        String contents = null;
        boolean checksumsValid = false;
        try {
            if (this.testChecksums(artifact, file)) {
                checksumsValid = true;
            }
            contents = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new ArtifactConversionException(Messages.getString("unable.to.read.source.pom", e.getMessage()), e);
        }
        if (checksumsValid && contents.indexOf("modelVersion") >= 0) {
            try {
                boolean matching = false;
                if (!this.force && targetFile.exists()) {
                    String targetContents = FileUtils.readFileToString((File)targetFile, (Charset)Charset.defaultCharset());
                    matching = targetContents.equals(contents);
                }
                if (!this.force) {
                    if (matching) return result;
                }
                transaction.createFile(contents, targetFile, this.digesters);
                return result;
            }
            catch (IOException e) {
                throw new ArtifactConversionException(Messages.getString("unable.to.write.target.pom", e.getMessage()), e);
            }
        }
        StringReader stringReader = new StringReader(contents);
        StringWriter writer = null;
        try {
            MavenXpp3Reader v3Reader = new MavenXpp3Reader();
            Model v3Model = v3Reader.read((Reader)stringReader);
            if (this.doRelocation(artifact, v3Model, targetRepository, transaction)) {
                Artifact relocatedPom = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                targetFile = new File(targetRepository.getBasedir(), targetRepository.pathOf(relocatedPom));
            }
            org.apache.maven.model.Model v4Model = this.translator.translate(v3Model);
            this.translator.validateV4Basics(v4Model, v3Model.getGroupId(), v3Model.getArtifactId(), v3Model.getVersion(), v3Model.getPackage());
            writer = new StringWriter();
            MavenXpp3Writer xpp3Writer = new MavenXpp3Writer();
            xpp3Writer.write((Writer)writer, v4Model);
            transaction.createFile(writer.toString(), targetFile, this.digesters);
            List warnings = this.translator.getWarnings();
            for (String message : warnings) {
                this.addWarning(artifact, message);
            }
            IOUtils.closeQuietly((Writer)writer);
            return result;
        }
        catch (XmlPullParserException e) {
            this.addWarning(artifact, Messages.getString("invalid.source.pom", e.getMessage()));
            result = false;
            return result;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (IOException e2) {
                throw new ArtifactConversionException(Messages.getString("unable.to.write.converted.pom"), e2);
                catch (PomTranslationException e3) {
                    this.addWarning(artifact, Messages.getString("invalid.source.pom", e3.getMessage()));
                    result = false;
                    return result;
                }
            }
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    private boolean testChecksums(Artifact artifact, File file) throws IOException {
        boolean result = true;
        for (Digester digester : this.digesters) {
            result &= this.verifyChecksum(file, file.getName() + "." + this.getDigesterFileExtension(digester), digester, artifact, "failure.incorrect." + this.getDigesterFileExtension(digester));
        }
        return result;
    }

    private boolean verifyChecksum(File file, String fileName, Digester digester, Artifact artifact, String key) throws IOException {
        boolean result = true;
        File checksumFile = new File(file.getParentFile(), fileName);
        if (checksumFile.exists()) {
            String checksum = FileUtils.readFileToString((File)checksumFile, (Charset)Charset.defaultCharset());
            try {
                digester.verify(file, checksum);
            }
            catch (DigesterException e) {
                this.addWarning(artifact, Messages.getString(key));
                result = false;
            }
        }
        return result;
    }

    private String getDigesterFileExtension(Digester digester) {
        return digester.getAlgorithm().toLowerCase().replaceAll("-", "");
    }

    private boolean copyArtifact(Artifact artifact, ArtifactRepository targetRepository, FileTransaction transaction) throws ArtifactConversionException {
        File sourceFile = artifact.getFile();
        if (sourceFile.getAbsolutePath().indexOf("/plugins/") > -1) {
            artifact.setArtifactHandler(this.artifactHandlerManager.getArtifactHandler("maven-plugin"));
        }
        File targetFile = new File(targetRepository.getBasedir(), targetRepository.pathOf(artifact));
        boolean result = true;
        try {
            boolean matching = false;
            if (!this.force && targetFile.exists() && !(matching = FileUtils.contentEquals((File)sourceFile, (File)targetFile))) {
                this.addWarning(artifact, Messages.getString("failure.target.already.exists"));
                result = false;
            }
            if (result && (this.force || !matching)) {
                if (this.testChecksums(artifact, sourceFile)) {
                    transaction.copyFile(sourceFile, targetFile, this.digesters);
                } else {
                    result = false;
                }
            }
        }
        catch (IOException e) {
            throw new ArtifactConversionException(Messages.getString("error.copying.artifact"), e);
        }
        return result;
    }

    private Metadata createBaseMetadata(Artifact artifact) {
        Metadata metadata = new Metadata();
        metadata.setArtifactId(artifact.getArtifactId());
        metadata.setGroupId(artifact.getGroupId());
        return metadata;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Metadata readMetadata(File file) throws ArtifactConversionException {
        Metadata metadata;
        MetadataXpp3Reader reader = new MetadataXpp3Reader();
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            metadata = reader.read((Reader)fileReader);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ArtifactConversionException(Messages.getString("error.reading.target.metadata"), e);
                catch (IOException e2) {
                    throw new ArtifactConversionException(Messages.getString("error.reading.target.metadata"), e2);
                }
                catch (XmlPullParserException e3) {
                    throw new ArtifactConversionException(Messages.getString("error.reading.target.metadata"), e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)fileReader);
        return metadata;
    }

    private boolean validateMetadata(Artifact artifact) throws ArtifactConversionException {
        Metadata metadata;
        ArtifactRepository repository = artifact.getRepository();
        boolean result = true;
        ArtifactRepositoryMetadata repositoryMetadata = new ArtifactRepositoryMetadata(artifact);
        File file = new File(repository.getBasedir(), repository.pathOfRemoteRepositoryMetadata((ArtifactMetadata)repositoryMetadata));
        if (file.exists()) {
            metadata = this.readMetadata(file);
            result = this.validateMetadata(metadata, (RepositoryMetadata)repositoryMetadata, artifact);
        }
        repositoryMetadata = new SnapshotArtifactRepositoryMetadata(artifact);
        file = new File(repository.getBasedir(), repository.pathOfRemoteRepositoryMetadata((ArtifactMetadata)repositoryMetadata));
        if (file.exists()) {
            metadata = this.readMetadata(file);
            result = result && this.validateMetadata(metadata, (RepositoryMetadata)repositoryMetadata, artifact);
        }
        return result;
    }

    private boolean validateMetadata(Metadata metadata, RepositoryMetadata repositoryMetadata, Artifact artifact) {
        String groupIdKey;
        String artifactIdKey = null;
        String snapshotKey = null;
        String versionKey = null;
        String versionsKey = null;
        if (repositoryMetadata.storedInGroupDirectory()) {
            groupIdKey = "failure.incorrect.groupMetadata.groupId";
        } else if (repositoryMetadata.storedInArtifactVersionDirectory()) {
            groupIdKey = "failure.incorrect.snapshotMetadata.groupId";
            artifactIdKey = "failure.incorrect.snapshotMetadata.artifactId";
            versionKey = "failure.incorrect.snapshotMetadata.version";
            snapshotKey = "failure.incorrect.snapshotMetadata.snapshot";
        } else {
            groupIdKey = "failure.incorrect.artifactMetadata.groupId";
            artifactIdKey = "failure.incorrect.artifactMetadata.artifactId";
            versionsKey = "failure.incorrect.artifactMetadata.versions";
        }
        boolean result = true;
        if (metadata.getGroupId() == null || !metadata.getGroupId().equals(artifact.getGroupId())) {
            this.addWarning(artifact, Messages.getString(groupIdKey));
            result = false;
        }
        if (!repositoryMetadata.storedInGroupDirectory()) {
            if (metadata.getGroupId() == null || !metadata.getArtifactId().equals(artifact.getArtifactId())) {
                this.addWarning(artifact, Messages.getString(artifactIdKey));
                result = false;
            }
            if (!repositoryMetadata.storedInArtifactVersionDirectory()) {
                boolean foundVersion = false;
                if (metadata.getVersioning() != null) {
                    for (String version : metadata.getVersioning().getVersions()) {
                        if (!version.equals(artifact.getBaseVersion())) continue;
                        foundVersion = true;
                        break;
                    }
                }
                if (!foundVersion) {
                    this.addWarning(artifact, Messages.getString(versionsKey));
                    result = false;
                }
            } else {
                Matcher matcher;
                if (!artifact.getBaseVersion().equals(metadata.getVersion())) {
                    this.addWarning(artifact, Messages.getString(versionKey));
                    result = false;
                }
                if (artifact.isSnapshot() && (matcher = Artifact.VERSION_FILE_PATTERN.matcher(artifact.getVersion())).matches()) {
                    boolean correct = false;
                    if (metadata.getVersioning() != null && metadata.getVersioning().getSnapshot() != null) {
                        Snapshot snapshot = metadata.getVersioning().getSnapshot();
                        int build = Integer.parseInt(matcher.group(3));
                        String ts = matcher.group(2);
                        if (build == snapshot.getBuildNumber() && ts.equals(snapshot.getTimestamp())) {
                            correct = true;
                        }
                    }
                    if (!correct) {
                        this.addWarning(artifact, Messages.getString(snapshotKey));
                        result = false;
                    }
                }
            }
        }
        return result;
    }

    private void updateMetadata(RepositoryMetadata artifactMetadata, ArtifactRepository targetRepository, Metadata newMetadata, FileTransaction transaction) throws ArtifactConversionException {
        boolean changed;
        Metadata metadata;
        File file = new File(targetRepository.getBasedir(), targetRepository.pathOfRemoteRepositoryMetadata((ArtifactMetadata)artifactMetadata));
        if (file.exists()) {
            metadata = this.readMetadata(file);
            changed = metadata.merge(newMetadata);
        } else {
            changed = true;
            metadata = newMetadata;
        }
        if (changed) {
            StringWriter writer = null;
            try {
                writer = new StringWriter();
                MetadataXpp3Writer mappingWriter = new MetadataXpp3Writer();
                mappingWriter.write((Writer)writer, metadata);
                transaction.createFile(writer.toString(), file, this.digesters);
            }
            catch (IOException e) {
                throw new ArtifactConversionException(Messages.getString("error.writing.target.metadata"), e);
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
    }

    private boolean doRelocation(Artifact artifact, Model v3Model, ArtifactRepository repository, FileTransaction transaction) throws IOException {
        Properties properties = v3Model.getProperties();
        if (properties.containsKey("relocated.groupId") || properties.containsKey("relocated.artifactId") || properties.containsKey("relocated.version")) {
            String newGroupId = properties.getProperty("relocated.groupId", v3Model.getGroupId());
            properties.remove("relocated.groupId");
            String newArtifactId = properties.getProperty("relocated.artifactId", v3Model.getArtifactId());
            properties.remove("relocated.artifactId");
            String newVersion = properties.getProperty("relocated.version", v3Model.getVersion());
            properties.remove("relocated.version");
            String message = properties.getProperty("relocated.message", "");
            properties.remove("relocated.message");
            if (properties.isEmpty()) {
                v3Model.setProperties(null);
            }
            this.writeRelocationPom(v3Model.getGroupId(), v3Model.getArtifactId(), v3Model.getVersion(), newGroupId, newArtifactId, newVersion, message, repository, transaction);
            v3Model.setGroupId(newGroupId);
            v3Model.setArtifactId(newArtifactId);
            v3Model.setVersion(newVersion);
            artifact.setGroupId(newGroupId);
            artifact.setArtifactId(newArtifactId);
            artifact.setVersion(newVersion);
            return true;
        }
        return false;
    }

    private void writeRelocationPom(String groupId, String artifactId, String version, String newGroupId, String newArtifactId, String newVersion, String message, ArtifactRepository repository, FileTransaction transaction) throws IOException {
        org.apache.maven.model.Model pom = new org.apache.maven.model.Model();
        pom.setGroupId(groupId);
        pom.setArtifactId(artifactId);
        pom.setVersion(version);
        DistributionManagement dMngt = new DistributionManagement();
        Relocation relocation = new Relocation();
        relocation.setGroupId(newGroupId);
        relocation.setArtifactId(newArtifactId);
        relocation.setVersion(newVersion);
        if (message != null && message.length() > 0) {
            relocation.setMessage(message);
        }
        dMngt.setRelocation(relocation);
        pom.setDistributionManagement(dMngt);
        Artifact artifact = this.artifactFactory.createBuildArtifact(groupId, artifactId, version, "pom");
        File pomFile = new File(repository.getBasedir(), repository.pathOf(artifact));
        StringWriter strWriter = new StringWriter();
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        pomWriter.write((Writer)strWriter, pom);
        transaction.createFile(strWriter.toString(), pomFile, this.digesters);
    }

    private void addWarning(Artifact artifact, String message) {
        List<String> messages = this.warnings.get(artifact);
        if (messages == null) {
            messages = new ArrayList<String>(1);
        }
        messages.add(message);
        this.warnings.put(artifact, messages);
    }

    @Override
    public void clearWarnings() {
        this.warnings.clear();
    }

    @Override
    public Map<Artifact, List<String>> getWarnings() {
        return this.warnings;
    }

    public List<? extends Digester> getDigesters() {
        return this.digesters;
    }

    public void setDigesters(List<Digester> digesters) {
        this.digesters = digesters;
    }

    public ModelConverter getTranslator() {
        return this.translator;
    }

    public void setTranslator(ModelConverter translator) {
        this.translator = translator;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public ArtifactHandlerManager getArtifactHandlerManager() {
        return this.artifactHandlerManager;
    }

    public void setArtifactHandlerManager(ArtifactHandlerManager artifactHandlerManager) {
        this.artifactHandlerManager = artifactHandlerManager;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isDryrun() {
        return this.dryrun;
    }

    public void setDryrun(boolean dryrun) {
        this.dryrun = dryrun;
    }
}

