/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.converter.legacy;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.common.utils.PathUtil;
import org.apache.archiva.converter.RepositoryConversionException;
import org.apache.archiva.converter.legacy.LegacyConverterArtifactConsumer;
import org.apache.archiva.converter.legacy.LegacyRepositoryConverter;
import org.apache.archiva.repository.scanner.RepositoryScanner;
import org.apache.archiva.repository.scanner.RepositoryScannerException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.springframework.stereotype.Service;

@Service(value="legacyRepositoryConverter#default")
public class DefaultLegacyRepositoryConverter
implements LegacyRepositoryConverter {
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactRepositoryLayout defaultLayout;
    @Inject
    @Named(value="knownRepositoryContentConsumer#artifact-legacy-to-default-converter")
    private LegacyConverterArtifactConsumer legacyConverterConsumer;
    @Inject
    private RepositoryScanner repoScanner;

    @Inject
    public DefaultLegacyRepositoryConverter(PlexusSisuBridge plexusSisuBridge) throws PlexusSisuBridgeException {
        this.artifactRepositoryFactory = (ArtifactRepositoryFactory)plexusSisuBridge.lookup(ArtifactRepositoryFactory.class);
        this.defaultLayout = (ArtifactRepositoryLayout)plexusSisuBridge.lookup(ArtifactRepositoryLayout.class, "default");
    }

    @Override
    public void convertLegacyRepository(File legacyRepositoryDirectory, File repositoryDirectory, List<String> fileExclusionPatterns) throws RepositoryConversionException {
        try {
            String defaultRepositoryUrl = PathUtil.toUrl((File)repositoryDirectory);
            ManagedRepository legacyRepository = new ManagedRepository();
            legacyRepository.setId("legacy");
            legacyRepository.setName("Legacy Repository");
            legacyRepository.setLocation(legacyRepositoryDirectory.getAbsolutePath());
            legacyRepository.setLayout("legacy");
            ArtifactRepository repository = this.artifactRepositoryFactory.createArtifactRepository("default", defaultRepositoryUrl, this.defaultLayout, null, null);
            this.legacyConverterConsumer.setExcludes(fileExclusionPatterns);
            this.legacyConverterConsumer.setDestinationRepository(repository);
            ArrayList<LegacyConverterArtifactConsumer> knownConsumers = new ArrayList<LegacyConverterArtifactConsumer>(1);
            knownConsumers.add(this.legacyConverterConsumer);
            List invalidConsumers = Collections.emptyList();
            ArrayList<String> ignoredContent = new ArrayList<String>(Arrays.asList(RepositoryScanner.IGNORABLE_CONTENT));
            this.repoScanner.scan(legacyRepository, knownConsumers, invalidConsumers, ignoredContent, 0L);
        }
        catch (RepositoryScannerException e) {
            throw new RepositoryConversionException("Error convering legacy repository.", e);
        }
    }
}

