/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.converter.legacy;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.archiva.consumers.ConsumerException;
import org.apache.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.archiva.converter.artifact.ArtifactConversionException;
import org.apache.archiva.converter.artifact.ArtifactConverter;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.content.maven2.ManagedDefaultRepositoryContent;
import org.apache.archiva.repository.layout.LayoutException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="knownRepositoryContentConsumer#artifact-legacy-to-default-converter")
@Scope(value="prototype")
public class LegacyConverterArtifactConsumer
extends AbstractMonitoredConsumer
implements KnownRepositoryContentConsumer {
    private Logger log = LoggerFactory.getLogger(LegacyConverterArtifactConsumer.class);
    @Inject
    private ArtifactConverter artifactConverter;
    private ArtifactFactory artifactFactory;
    private ManagedRepositoryContent managedRepository;
    private ArtifactRepository destinationRepository;
    private List<String> includes = new ArrayList<String>(3);
    private List<String> excludes;

    @Inject
    public LegacyConverterArtifactConsumer(PlexusSisuBridge plexusSisuBridge) throws PlexusSisuBridgeException {
        this.includes.add("**/*.jar");
        this.includes.add("**/*.ear");
        this.includes.add("**/*.war");
        this.artifactFactory = (ArtifactFactory)plexusSisuBridge.lookup(ArtifactFactory.class);
    }

    public void beginScan(ManagedRepository repository, Date whenGathered) throws ConsumerException {
        this.managedRepository = new ManagedDefaultRepositoryContent();
        this.managedRepository.setRepository(repository);
    }

    public void beginScan(ManagedRepository repository, Date whenGathered, boolean executeOnEntireRepo) throws ConsumerException {
        this.beginScan(repository, whenGathered);
    }

    public void completeScan() {
    }

    public void completeScan(boolean executeOnEntireRepo) {
        this.completeScan();
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void processFile(String path) throws ConsumerException {
        try {
            ArtifactReference reference = this.managedRepository.toArtifactReference(path);
            Artifact artifact = this.artifactFactory.createArtifact(reference.getGroupId(), reference.getArtifactId(), reference.getVersion(), reference.getClassifier(), reference.getType());
            this.artifactConverter.convert(artifact, this.destinationRepository);
        }
        catch (LayoutException e) {
            this.log.warn("Unable to convert artifact: {} : {}", new Object[]{path, e.getMessage(), e});
        }
        catch (ArtifactConversionException e) {
            this.log.warn("Unable to convert artifact: {} : {}", new Object[]{path, e.getMessage(), e});
        }
    }

    public void processFile(String path, boolean executeOnEntireRepo) throws Exception {
        this.processFile(path);
    }

    public String getDescription() {
        return "Legacy Artifact to Default Artifact Converter";
    }

    public String getId() {
        return "artifact-legacy-to-default-converter";
    }

    public boolean isPermanent() {
        return false;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public ArtifactRepository getDestinationRepository() {
        return this.destinationRepository;
    }

    public void setDestinationRepository(ArtifactRepository destinationRepository) {
        this.destinationRepository = destinationRepository;
    }
}

