/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.browsing;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.common.utils.VersionUtil;
import org.apache.maven.archiva.database.ArchivaDAO;
import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.database.ObjectNotFoundException;
import org.apache.maven.archiva.database.browsing.BrowsingResults;
import org.apache.maven.archiva.database.browsing.GroupIdFilter;
import org.apache.maven.archiva.database.browsing.RepositoryBrowsing;
import org.apache.maven.archiva.database.constraints.ProjectsByArtifactUsageConstraint;
import org.apache.maven.archiva.database.constraints.UniqueArtifactIdConstraint;
import org.apache.maven.archiva.database.constraints.UniqueGroupIdConstraint;
import org.apache.maven.archiva.database.constraints.UniqueVersionConstraint;
import org.apache.maven.archiva.database.updater.DatabaseUpdater;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.model.ArchivaProjectModel;
import org.apache.maven.archiva.model.Keys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryBrowsing
implements RepositoryBrowsing {
    private Logger log = LoggerFactory.getLogger(DefaultRepositoryBrowsing.class);
    private ArchivaDAO dao;
    private DatabaseUpdater dbUpdater;

    @Override
    public BrowsingResults getRoot(String principle, List<String> observableRepositoryIds) {
        List groups = this.dao.query(new UniqueGroupIdConstraint(observableRepositoryIds));
        BrowsingResults results = new BrowsingResults();
        results.setSelectedRepositoryIds(observableRepositoryIds);
        results.setGroupIds(GroupIdFilter.filterGroups(groups));
        return results;
    }

    @Override
    public BrowsingResults selectArtifactId(String principle, List<String> observableRepositoryIds, String groupId, String artifactId) {
        List versions = this.dao.query(new UniqueVersionConstraint(observableRepositoryIds, groupId, artifactId));
        BrowsingResults results = new BrowsingResults(groupId, artifactId);
        results.setSelectedRepositoryIds(observableRepositoryIds);
        this.processSnapshots(versions);
        results.setVersions(versions);
        return results;
    }

    @Override
    public BrowsingResults selectGroupId(String principle, List<String> observableRepositoryIds, String groupId) {
        List groups = this.dao.query(new UniqueGroupIdConstraint(observableRepositoryIds, groupId));
        List artifacts = this.dao.query(new UniqueArtifactIdConstraint(observableRepositoryIds, groupId));
        BrowsingResults results = new BrowsingResults(groupId);
        CollectionUtils.filter((Collection)groups, (Predicate)NotPredicate.getInstance((Predicate)PredicateUtils.equalPredicate((Object)groupId)));
        results.setGroupIds(groups);
        results.setArtifacts(artifacts);
        return results;
    }

    @Override
    public ArchivaProjectModel selectVersion(String principle, List<String> observableRepositoryIds, String groupId, String artifactId, String version) throws ObjectNotFoundException, ArchivaDatabaseException {
        ArchivaArtifact pomArtifact = this.getArtifact(principle, observableRepositoryIds, groupId, artifactId, version);
        version = pomArtifact.getVersion();
        if (!pomArtifact.getModel().isProcessed()) {
            this.dbUpdater.updateUnprocessed(pomArtifact);
        }
        ArchivaProjectModel model = this.getProjectModel(groupId, artifactId, version);
        return model;
    }

    @Override
    public String getRepositoryId(String principle, List<String> observableRepositoryIds, String groupId, String artifactId, String version) throws ObjectNotFoundException, ArchivaDatabaseException {
        ArchivaArtifact pomArchivaArtifact = this.getArtifact(principle, observableRepositoryIds, groupId, artifactId, version);
        return pomArchivaArtifact.getModel().getRepositoryId();
    }

    private ArchivaArtifact getArtifact(String principle, List<String> observableRepositoryIds, String groupId, String artifactId, String version) throws ObjectNotFoundException, ArchivaDatabaseException {
        ArchivaArtifact pomArtifact = null;
        try {
            pomArtifact = this.dao.getArtifactDAO().getArtifact(groupId, artifactId, version, null, "pom");
        }
        catch (ObjectNotFoundException e) {
            pomArtifact = this.handleGenericSnapshots(groupId, artifactId, version, pomArtifact);
        }
        if (pomArtifact == null) {
            throw new ObjectNotFoundException("Unable to find artifact [" + Keys.toKey((String)groupId, (String)artifactId, (String)version) + "]");
        }
        if (observableRepositoryIds.contains(pomArtifact.getModel().getRepositoryId())) {
            return pomArtifact;
        }
        throw new ObjectNotFoundException("Unable to find artifact " + Keys.toKey((String)groupId, (String)artifactId, (String)version) + " in observable repository [" + StringUtils.join(observableRepositoryIds.iterator(), (String)", ") + "] for user " + principle);
    }

    @Override
    public List<ArchivaProjectModel> getUsedBy(String principle, List<String> observableRepositoryIds, String groupId, String artifactId, String version) throws ArchivaDatabaseException {
        ProjectsByArtifactUsageConstraint constraint = new ProjectsByArtifactUsageConstraint(groupId, artifactId, version);
        List<ArchivaProjectModel> results = this.dao.getProjectModelDAO().queryProjectModels(constraint);
        if (results == null) {
            return Collections.EMPTY_LIST;
        }
        return results;
    }

    private void processSnapshots(List<String> versions) {
        String baseVersion;
        HashMap<String, String> snapshots = new HashMap<String, String>();
        this.log.info("Processing snapshots.");
        for (String string : versions) {
            if (!VersionUtil.isSnapshot((String)string) || snapshots.containsKey(baseVersion = VersionUtil.getBaseVersion((String)string))) continue;
            snapshots.put(baseVersion, baseVersion);
        }
        for (Map.Entry entry : snapshots.entrySet()) {
            baseVersion = (String)entry.getValue();
            if (versions.contains(baseVersion)) continue;
            versions.add(baseVersion);
        }
    }

    private ArchivaArtifact handleGenericSnapshots(String groupId, String artifactId, String version, ArchivaArtifact pomArtifact) throws ArchivaDatabaseException {
        if (VersionUtil.isGenericSnapshot((String)version)) {
            List versions = this.dao.query(new UniqueVersionConstraint(groupId, artifactId));
            Collections.sort(versions);
            Collections.reverse(versions);
            for (String uniqueVersion : versions) {
                if (!VersionUtil.getBaseVersion((String)uniqueVersion).equals(version)) continue;
                this.log.info("Retrieving artifact with version " + uniqueVersion);
                pomArtifact = this.dao.getArtifactDAO().getArtifact(groupId, artifactId, uniqueVersion, null, "pom");
                return pomArtifact;
            }
        }
        return null;
    }

    private ArchivaProjectModel getProjectModel(String groupId, String artifactId, String version) throws ArchivaDatabaseException {
        ArchivaProjectModel model = this.dao.getProjectModelDAO().getProjectModel(groupId, artifactId, version);
        if (model == null) {
            throw new ObjectNotFoundException("Unable to find project model for [" + Keys.toKey((String)groupId, (String)artifactId, (String)version) + "]");
        }
        return model;
    }
}

