/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.constraints;

import java.util.Date;
import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.constraints.AbstractDeclarativeConstraint;

public class ArtifactsByRepositoryConstraint
extends AbstractDeclarativeConstraint
implements Constraint {
    private String whereClause;
    private String sortColumn = "groupId";

    public ArtifactsByRepositoryConstraint(String repoId) {
        this.whereClause = "repositoryId == repoId";
        this.declParams = new String[]{"String repoId"};
        this.params = new Object[]{repoId};
    }

    public ArtifactsByRepositoryConstraint(String repoId, Date targetWhenGathered, String sortColumn) {
        this.declImports = new String[]{"import java.util.Date"};
        this.whereClause = "this.repositoryId == repoId && this.whenGathered >= targetWhenGathered";
        this.declParams = new String[]{"String repoId", "Date targetWhenGathered"};
        this.params = new Object[]{repoId, targetWhenGathered};
        this.sortColumn = sortColumn;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public String getWhereCondition() {
        return this.whereClause;
    }
}

