/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.constraints;

import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.constraints.RangeConstraint;

public class RepositoryProblemConstraint
extends RangeConstraint
implements Constraint {
    private String whereClause;

    private void createWhereClause(String desiredGroupId, String desiredRepositoryId) {
        this.whereClause = "groupId.like(desiredGroupId) && repositoryId == desiredRepositoryId";
        this.declParams = new String[]{"String desiredGroupId", "String desiredRepositoryId"};
        this.params = new Object[]{desiredGroupId + "%", desiredRepositoryId};
    }

    public RepositoryProblemConstraint(String desiredGroupId, String desiredRepositoryId) {
        this.createWhereClause(desiredGroupId, desiredRepositoryId);
    }

    public RepositoryProblemConstraint(int[] range, String desiredGroupId, String desiredRepositoryId) {
        super(range);
        this.createWhereClause(desiredGroupId, desiredRepositoryId);
    }

    public String getSortColumn() {
        return "artifactId";
    }

    public String getWhereCondition() {
        return this.whereClause;
    }
}

