/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.constraints;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.constraints.AbstractSimpleConstraint;
import org.apache.maven.archiva.database.constraints.SqlBuilder;
import org.apache.maven.archiva.model.ArchivaArtifactModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueVersionConstraint
extends AbstractSimpleConstraint
implements Constraint {
    private StringBuffer sql = new StringBuffer();

    public UniqueVersionConstraint(List<String> selectedRepositoryIds, String groupId, String artifactId) {
        if (StringUtils.isBlank((String)groupId)) {
            throw new IllegalArgumentException("A blank groupId is not allowed.");
        }
        if (StringUtils.isBlank((String)artifactId)) {
            throw new IllegalArgumentException("A blank artifactId is not allowed.");
        }
        this.appendSelect(this.sql);
        this.sql.append(" WHERE ");
        SqlBuilder.appendWhereSelectedRepositories(this.sql, "repositoryId", selectedRepositoryIds);
        this.sql.append(" && ");
        this.appendWhereSelectedGroupIdArtifactId(this.sql);
        this.appendGroupBy(this.sql);
        this.params = new Object[]{groupId, artifactId};
    }

    public UniqueVersionConstraint(String groupId, String artifactId) {
        if (StringUtils.isBlank((String)groupId)) {
            throw new IllegalArgumentException("A blank groupId is not allowed.");
        }
        if (StringUtils.isBlank((String)artifactId)) {
            throw new IllegalArgumentException("A blank artifactId is not allowed.");
        }
        this.appendSelect(this.sql);
        this.sql.append(" WHERE ");
        this.appendWhereSelectedGroupIdArtifactId(this.sql);
        this.appendGroupBy(this.sql);
        this.params = new Object[]{groupId, artifactId};
    }

    @Override
    public Class getResultClass() {
        return String.class;
    }

    @Override
    public String getSelectSql() {
        return this.sql.toString();
    }

    private void appendGroupBy(StringBuffer buf) {
        buf.append(" GROUP BY version ORDER BY version ASCENDING");
    }

    private void appendSelect(StringBuffer buf) {
        buf.append("SELECT version FROM ").append(ArchivaArtifactModel.class.getName());
    }

    private void appendWhereSelectedGroupIdArtifactId(StringBuffer buf) {
        buf.append(" groupId == selectedGroupId && artifactId == selectedArtifactId");
        buf.append(" PARAMETERS String selectedGroupId, String selectedArtifactId");
    }
}

